CREATE TABLE `form_field_info`
(
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `formAliasName` varchar(100) DEFAULT NULL,
    `formFieldName` varchar(70) DEFAULT NULL,
    `formFieldId` varchar(50) DEFAULT NULL,
    `formFieldLabel` varchar(70) DEFAULT NULL,
    `formFieldInputType` varchar(30) DEFAULT NULL,
    `isMandatory` tinyint(1) NOT NULL,
    `isLocked` tinyint(1) NOT NULL,   
    `defaultValue` varchar(30) DEFAULT NULL,
    `formFieldDefaultHelpText` varchar(255) DEFAULT NULL,
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
KEY `fk_form_field_info_lastUpdatedBy_idx` (`lastUpdatedBy`),
CONSTRAINT `fk_form_field_info_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `form_field_display_settings`
(
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `academyLocationId` bigint(20) NOT NULL,
    `formFieldInfoId` bigint(20) NOT NULL,
    `formFieldLabel` varchar(70) DEFAULT NULL,
    `isVisible` tinyint(1) NOT NULL,
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
KEY `fk_form_field_display_settings_alid_idx` (`academyLocationId`),
KEY `fk_form_field_display_settings_info_id_idx` (`formFieldInfoId`),
KEY `fk_form_field_display_settings_updatedBy_idx` (`lastUpdatedBy`),
CONSTRAINT `fk_form_field_display_settings_alid` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
CONSTRAINT `fk_form_field_display_settings_info_id` FOREIGN KEY (`formFieldInfoId`) REFERENCES `form_field_info` (`id`),
CONSTRAINT `fk_form_field_display_settings_updatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `form_field_helptext_lang_translation`
(
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `formFieldDisplaySettingsId` bigint(20) NOT NULL,
    `languageCode` varchar(70) DEFAULT NULL,
    `formFieldHelpText` varchar(255) DEFAULT NULL,
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
KEY `fk_form_field_helptext_lang_translation_idx` (`lastUpdatedBy`),
CONSTRAINT `fk_form_field_helptext_lang_translation` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

ALTER TABLE `form_field_helptext_lang_translation` 
ADD INDEX `fk_form_field_helptext_lang_translation_1_idx` (`formFieldDisplaySettingsId` ASC);
ALTER TABLE `form_field_helptext_lang_translation` 
ADD CONSTRAINT `fk_form_field_helptext_lang_translation_1`
  FOREIGN KEY (`formFieldDisplaySettingsId`)
  REFERENCES `form_field_display_settings` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;