CREATE TABLE `voucher_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountingReference` varchar(255) DEFAULT NULL,
  `billType` varchar(255) DEFAULT NULL,
  `consolidationDate` date DEFAULT NULL,
  `createdFrom` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL,
  `postingDate` date DEFAULT NULL,
  `receiptType` varchar(255) DEFAULT NULL,
  `totalAmount` double DEFAULT NULL,
  `voucherAmount` double DEFAULT NULL,
  `voucherDate` date DEFAULT NULL,
  `voucherFlag` varchar(255) DEFAULT NULL,
  `voucherID` varchar(255) DEFAULT NULL,
  `voucherMode` varchar(255) DEFAULT NULL,
  `voucherNarration` varchar(255) DEFAULT NULL,
  `voucherStatus` varchar(255) DEFAULT NULL,
  `voucherType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `vouchercurrencyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `voucher_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccountKey` varchar(255) DEFAULT NULL,
  `credit` double DEFAULT NULL,
  `debit` double DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `subLedgerAccountKey` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `voucherId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `account_balances_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountType` varchar(255) DEFAULT NULL,
  `accountingYear` varchar(255) DEFAULT NULL,
  `controlAccountKey` varchar(255) DEFAULT NULL,
  `creditTotal` double DEFAULT NULL,
  `debitTotal` double DEFAULT NULL,
  `subLedgerAccountKey` varchar(255) DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `iau_batch_import_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `batchImportDate` date DEFAULT NULL,
  `totalAccountImported` int(11) DEFAULT NULL,
  `totalSubledgerImported` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `iau_batch_posting_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `batchPostingDate` date DEFAULT NULL,
  `totalAmountFailed` double DEFAULT NULL,
  `totalAmountPosted` double DEFAULT NULL,
  `voucherFailed` int(11) DEFAULT NULL,
  `vouchersPosted` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
