DROP TABLE IF EXISTS `course_reading_history`;

CREATE TABLE `course_reading_history` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4),
  `linkPath` TEXT,
  `academicYear` INT(11) DEFAULT NULL,
  `courseId` BIGINT(20) DEFAULT NULL,
  `distributionModeId` BIGINT(20) DEFAULT NULL,
  `invtItemMasterId` BIGINT(20) NOT NULL,
  `whetherCompulsory` BIT(1) NOT NULL,
  `topicType` VARCHAR(35) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` DATETIME NOT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=INNODB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- invt_distribution_list_history

CREATE TABLE `invt_distribution_list_history`(
 `id` BIGINT(20) NOT NULL, 
 `REV` INT(11) NOT NULL,
 `REVTYPE` TINYINT(4),
 `listName` VARCHAR(200) NOT NULL,
 `programId` BIGINT(20),
 `batchId` BIGINT(20),
 `periodId` BIGINT(20),
 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 `lastUpdatedBy` BIGINT(20),
  PRIMARY KEY (`id`,`REV`));

-- invt_distribution_item_list_history

CREATE TABLE `invt_distribution_item_list_history`( 
`id` BIGINT(20) NOT NULL,
`REV` INT(11) NOT NULL,
`REVTYPE` TINYINT(4),
`invtDistListId` BIGINT(20),
`courseReadingId` BIGINT(20),
`courseReadingVariantId` BIGINT(20),
`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20),
 PRIMARY KEY (`id`,`REV`));

-- invt_student_distribution_history

CREATE TABLE `invt_student_distribution_history`(
 `id` BIGINT(20) NOT NULL,
 `REV` INT(11) NOT NULL,
 `REVTYPE` TINYINT(4),
 `studentId` BIGINT(20),
 `packetNo` VARCHAR(200),
 `consignmentNo` VARCHAR(200),
 `sentBy` BIGINT(20),
 `serviceProvider` VARCHAR(200),
 `sentDate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
 `remarks` TEXT,
 `studentAddress` TEXT,
 `packetStatus` VARCHAR(50),
 `inventoryDistributionListId` BIGINT(20),
 `returnedDate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
 `deliveredDate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
 `POD` VARCHAR(200),
 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
 `lastUpdatedBy` BIGINT(20),
 PRIMARY KEY (`id`,`REV`));


-- invt_student_distribution_detail_history

CREATE TABLE `invt_student_distribution_detail_history`(
 `id` BIGINT(20) NOT NULL,
 `REV` INT(11) NOT NULL,
 `REVTYPE` TINYINT(4),
 `inventoryStudentDistributionId` BIGINT(20),
 `courseReadingVariantId` BIGINT(20),
 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
 `lastUpdatedBy` BIGINT(20),
 PRIMARY KEY (`id`,`REV`));