/********SG Visitor Category History******/
CREATE TABLE `sg_visitor_category_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/***** SG Visitor Card History*********/
CREATE TABLE `sg_visitor_card_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*******SG Manage Visitors History**********/
CREATE TABLE `sg_manage_visitors_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `isAppointment` bit(1) DEFAULT b'0',
  `visitorCategoryId` bigint(20) NOT NULL,
  `visitorNo` varchar(45) NOT NULL,
  `visitorCardNo` varchar(45) NOT NULL,
  `personImagePath` varchar(45) DEFAULT NULL,
  `visitorName` varchar(45) DEFAULT NULL,
  `visitorContactNo` varchar(12) DEFAULT NULL,
  `visitorEmailId` varchar(45) DEFAULT NULL,
  `visitorVehicleNo` varchar(20) DEFAULT NULL,
  `visitorOrganization` varchar(45) DEFAULT NULL,
  `visitorPlace` varchar(45) DEFAULT NULL,
  `bookingId` varchar(45) DEFAULT NULL,
  `visitorAddress` varchar(255) DEFAULT NULL,
  `inTime` time NOT NULL,
  `outTime` time DEFAULT NULL,
  `reasonToVisit` varchar(255) DEFAULT NULL,
  `personToMeet` varchar(45) NOT NULL,
  `personContactNo` varchar(45) DEFAULT NULL,
  `meetingDate` date DEFAULT NULL,
  `entryBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `isGoingOutWithStudent` bit(1) NOT NULL DEFAULT b'0',
  `isMultiDayPass` bit(1) DEFAULT b'0',
  `tillDate` date DEFAULT NULL,
  `isParentOrGardian` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/******SG Appointment History***********/
CREATE TABLE `sg_appointment_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `visitorCategoryId` bigint(20) NOT NULL,
  `bookingId` varchar(255) NOT NULL,
  `appointeeName` varchar(255) NOT NULL,
  `appointeeContactNo` varchar(12) DEFAULT NULL,
  `appointeeEmailId` varchar(45) DEFAULT NULL,
  `bookingDate` date NOT NULL,
  `appointmentDate` date NOT NULL,
  `personToMeet` varchar(255) NOT NULL,
  `visitTime` time NOT NULL,
  `expectedOutTime` time DEFAULT NULL,
  `reasonToVisit` text,
  `entryBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
