DELIMITER $$

DROP PROCEDURE IF EXISTS V202001091505__CreateInvoiceCurrencyHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001091505__CreateInvoiceCurrencyHistory()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='invoice_currency_history' )) THEN
    
	CREATE TABLE `invoice_currency_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `invoiceCurrencyName` varchar(100) DEFAULT NULL,
  `invoiceCurrencyCode` varchar(10) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	
  END IF;

END $$

-- Execute the stored procedure
CALL V202001091505__CreateInvoiceCurrencyHistory() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001091505__CreateInvoiceCurrencyHistory $$
 
DELIMITER ;