DELIMITER $$

DROP PROCEDURE IF EXISTS ValidFrom $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE ValidFrom()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='currency_exchange_rate_audit'
  AND column_name='validFrom')) THEN
  
  ALTER TABLE `currency_exchange_rate_audit` CHANGE COLUMN `validFrom` `validFrom` DATE NULL DEFAULT NULL ;
  
  END IF;

END $$

-- Execute the stored procedure
CALL ValidFrom() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS ValidFrom $$
 
DELIMITER ;