DELIMITER $$
DROP PROCEDURE IF EXISTS V20200618163148__Create_Learning_Target_History $$
CREATE PROCEDURE V20200618163148__Create_Learning_Target_History()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target_history' )) THEN 
	CREATE TABLE `learning_target_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `reviewDate` DATE NOT NULL,
  `nextReviewDate` DATE NULL DEFAULT NULL,
  `facultyComment` VARCHAR(1000) NULL DEFAULT NULL,
  `studentComment` VARCHAR(1000) NULL DEFAULT NULL,
  `admissionId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target_details_history' )) THEN 
	CREATE TABLE `learning_target_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `learningTargetId` BIGINT NOT NULL,
  `courseId` BIGINT NOT NULL,
  `targetGradeMarks` VARCHAR(255) NULL DEFAULT NULL,
  `targetAttendance` VARCHAR(20) NULL DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 


END $$
CALL V20200618163148__Create_Learning_Target_History () $$ 
DROP PROCEDURE IF EXISTS V20200618163148__Create_Learning_Target_History $$ 
DELIMITER ;