DELIMITER $$

DROP PROCEDURE IF EXISTS V20201221095708__Insert_AchievementTypeCSMAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201221095708__Insert_AchievementTypeCSMAudit()

BEGIN
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='achievement_type_history' )) THEN
  
  CREATE TABLE `achievement_type_history` (
		  `id` bigint(20) NOT NULL,
		  `REV` bigint(20) NOT NULL,
		  `REVTYPE` tinyint(4) DEFAULT NULL,
		  `itemCode` varchar(255) DEFAULT NULL,
		  `itemValue` varchar(255) DEFAULT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V20201221095708__Insert_AchievementTypeCSMAudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201221095708__Insert_AchievementTypeCSMAudit $$
 
DELIMITER ;