DELIMITER $$
DROP PROCEDURE IF EXISTS V20250708150206__Alter_transferCreditExtIntHistory $$
CREATE PROCEDURE V20250708150206__Alter_transferCreditExtIntHistory()
BEGIN

 IF EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit_history'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'remark'
  ) THEN
    ALTER TABLE `exam_transfer_credit_history`
      CHANGE COLUMN `remark` `studentRemark` VARCHAR(255) DEFAULT NULL;
  END IF;

  -- 2. Add 'facultyRemark' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit_history'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyRemark'
  ) THEN
    ALTER TABLE `exam_transfer_credit_history`
      ADD COLUMN `facultyRemark` VARCHAR(255) DEFAULT NULL AFTER `studentRemark`;
  END IF;

  -- 3. Add 'facultyApproverDate' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit_history'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyApproverDate'
  ) THEN
    ALTER TABLE `exam_transfer_credit_history`
      ADD COLUMN `facultyApproverDate` DATE DEFAULT NULL AFTER `facultyRemark`;
  END IF;

  -- 4. Add 'facultyApproverId' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit_history'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyApproverId'
  ) THEN
    ALTER TABLE `exam_transfer_credit_history`
      ADD COLUMN `facultyApproverId` BIGINT DEFAULT NULL AFTER `facultyApproverDate`;
  END IF;

  -- 5. Add 'completionDate' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit_history'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'completionDate'
  ) THEN
    ALTER TABLE `exam_transfer_credit_history`
      ADD COLUMN `completionDate` DATE DEFAULT NULL AFTER `facultyApproverId`;
  END IF;

END $$
CALL V20250708150206__Alter_transferCreditExtIntHistory() $$
DROP PROCEDURE IF EXISTS V20250708150206__Alter_transferCreditExtIntHistory $$
DELIMITER ;