SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `adhoc_msg_event_config`;

CREATE TABLE `adhoc_msg_event_config` (
  `msgEventCnfgId` bigint(20) DEFAULT NULL,
  `msgSubCatagoryId` bigint(20) DEFAULT NULL,
  `msgDueDate` date DEFAULT NULL,
  `adhocRcpntPrvdrId` bigint(20) DEFAULT NULL,
  `reviewStatusCode` varchar(50) DEFAULT NULL,
  KEY `Ref4296` (`msgEventCnfgId`),
  KEY `Ref35134` (`msgSubCatagoryId`),
  CONSTRAINT `Refmsg_catagory134` FOREIGN KEY (`msgSubCatagoryId`) REFERENCES `msg_catagory` (`id`),
  CONSTRAINT `Refmsg_event_config96` FOREIGN KEY (`msgEventCnfgId`) REFERENCES `msg_event_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `adhoc_msg_event_config` */

/*Table structure for table `adhoc_msg_review` */

DROP TABLE IF EXISTS `adhoc_msg_review`;

CREATE TABLE `adhoc_msg_review` (
  `id` bigint(20) NOT NULL,
  `adhocMsgEventCnfgId` bigint(20) DEFAULT NULL,
  `reviewerId` bigint(20) DEFAULT NULL,
  `reviewComment` varchar(200) DEFAULT NULL,
  `reviewTimeStamp` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref42125` (`adhocMsgEventCnfgId`),
  CONSTRAINT `Refmsg_event_config125` FOREIGN KEY (`adhocMsgEventCnfgId`) REFERENCES `msg_event_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `adhoc_msg_review` */

/*Table structure for table `adhoc_rcpnt_drule_prvdr` */

DROP TABLE IF EXISTS `adhoc_rcpnt_drule_prvdr`;

CREATE TABLE `adhoc_rcpnt_drule_prvdr` (
  `id` bigint(20) NOT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref32106` (`recipientTypeId`),
  KEY `Ref44107` (`dataProviderId`),
  CONSTRAINT `Refdtprovider107` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`),
  CONSTRAINT `Refmsg_recipient_type106` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `adhoc_rcpnt_drule_prvdr` */

/*Table structure for table `cb_dtprovider` */

DROP TABLE IF EXISTS `cb_dtprovider`;

CREATE TABLE `cb_dtprovider` (
  `id` bigint(20) NOT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  `searchConfigCode` varchar(100) NOT NULL,
  `searchResultViewCode` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref4480` (`dataProviderId`),
  CONSTRAINT `Refdtprovider80` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `cb_dtprovider` */

/*Table structure for table `drool_dtprovider` */

DROP TABLE IF EXISTS `drool_dtprovider`;

CREATE TABLE `drool_dtprovider` (
  `id` bigint(20) NOT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  `droolAgendaId` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref4481` (`dataProviderId`),
  CONSTRAINT `Refdtprovider81` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `drool_dtprovider` */

/*Table structure for table `dtprovider` */

DROP TABLE IF EXISTS `dtprovider`;

CREATE TABLE `dtprovider` (
  `id` bigint(20) NOT NULL,
  `dataProviderName` varchar(50) DEFAULT NULL,
  `dataProviderType` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dtprovider` */

/*Table structure for table `dtprvdr_input_param` */

DROP TABLE IF EXISTS `dtprvdr_input_param`;

CREATE TABLE `dtprvdr_input_param` (
  `id` bigint(20) NOT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  `paramName` varchar(50) NOT NULL,
  `paramScope` varchar(50) NOT NULL,
  `paramDataType` varchar(50) DEFAULT NULL,
  `ParamType` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref4479` (`dataProviderId`),
  CONSTRAINT `Refdtprovider79` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dtprvdr_input_param` */

/*Table structure for table `dtprvdr_instance` */

DROP TABLE IF EXISTS `dtprvdr_instance`;

CREATE TABLE `dtprvdr_instance` (
  `id` bigint(20) NOT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  `savedRuleRefId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref44139` (`dataProviderId`),
  CONSTRAINT `Refdtprovider139` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dtprvdr_instance` */

/*Table structure for table `dtprvdr_instnc_input_param` */

DROP TABLE IF EXISTS `dtprvdr_instnc_input_param`;

CREATE TABLE `dtprvdr_instnc_input_param` (
  `id` bigint(20) NOT NULL,
  `ruleInstanceId` bigint(20) DEFAULT NULL,
  `msgScopeParamId` bigint(20) DEFAULT NULL,
  `paramValue` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref48136` (`ruleInstanceId`),
  KEY `Ref37137` (`msgScopeParamId`),
  CONSTRAINT `Refdtprvdr_instance136` FOREIGN KEY (`ruleInstanceId`) REFERENCES `dtprvdr_instance` (`id`),
  CONSTRAINT `Refmsg_scope_param137` FOREIGN KEY (`msgScopeParamId`) REFERENCES `msg_scope_param` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dtprvdr_instnc_input_param` */

/*Table structure for table `msg_catagory` */

DROP TABLE IF EXISTS `msg_catagory`;

CREATE TABLE `msg_catagory` (
  `id` bigint(20) NOT NULL,
  `parentCatgory` bigint(20) DEFAULT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3566` (`parentCatgory`),
  CONSTRAINT `Refmsg_catagory66` FOREIGN KEY (`parentCatgory`) REFERENCES `msg_catagory` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_catagory` */

/*Table structure for table `msg_config_level` */

DROP TABLE IF EXISTS `msg_config_level`;

CREATE TABLE `msg_config_level` (
  `id` bigint(20) NOT NULL,
  `code` varchar(50) NOT NULL,
  `uiComponentReference` varchar(20) DEFAULT NULL,
  `displayCode` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_config_level` */

/*Table structure for table `msg_delivery_mode` */

DROP TABLE IF EXISTS `msg_delivery_mode`;

CREATE TABLE `msg_delivery_mode` (
  `id` bigint(20) NOT NULL,
  `code` varchar(50) NOT NULL,
  `whetherMsgSubjAvail` bit(1) DEFAULT NULL,
  `whetherAttachmentSupported` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_delivery_mode` */

/*Table structure for table `msg_delivery_mode_log` */

DROP TABLE IF EXISTS `msg_delivery_mode_log`;

CREATE TABLE `msg_delivery_mode_log` (
  `id` bigint(20) NOT NULL,
  `msgRcpntTypeLogId` bigint(20) DEFAULT NULL,
  `msgDeliveryModeId` bigint(20) DEFAULT NULL,
  `failureCount` int(11) DEFAULT NULL,
  `successCount` char(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref62122` (`msgRcpntTypeLogId`),
  KEY `Ref70151` (`msgDeliveryModeId`),
  CONSTRAINT `Refmsg_delivery_mode151` FOREIGN KEY (`msgDeliveryModeId`) REFERENCES `msg_delivery_mode` (`id`),
  CONSTRAINT `Refmsg_rcpnt_type_log122` FOREIGN KEY (`msgRcpntTypeLogId`) REFERENCES `msg_rcpnt_type_log` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_delivery_mode_log` */

/*Table structure for table `msg_event_config` */

DROP TABLE IF EXISTS `msg_event_config`;

CREATE TABLE `msg_event_config` (
  `id` bigint(20) NOT NULL,
  `msgTemplateCnfgId` bigint(20) DEFAULT NULL,
  `msgCnfgLevelId` bigint(20) DEFAULT NULL,
  `msgConfigLevelValue` bigint(20) DEFAULT NULL,
  `sendingPriority` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3875` (`msgTemplateCnfgId`),
  KEY `Ref3376` (`msgCnfgLevelId`),
  CONSTRAINT `Refmsg_config_level76` FOREIGN KEY (`msgCnfgLevelId`) REFERENCES `msg_config_level` (`id`),
  CONSTRAINT `Refmsg_template_config75` FOREIGN KEY (`msgTemplateCnfgId`) REFERENCES `msg_template_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_event_config` */

/*Table structure for table `msg_event_recepient_config` */

DROP TABLE IF EXISTS `msg_event_recepient_config`;

CREATE TABLE `msg_event_recepient_config` (
  `id` bigint(20) NOT NULL,
  `msgEventCnfgId` bigint(20) DEFAULT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  `distrListInstanceId` bigint(20) DEFAULT NULL,
  `distrRuleInstanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3278` (`recipientTypeId`),
  KEY `Ref4886` (`distrListInstanceId`),
  KEY `Ref4887` (`distrRuleInstanceId`),
  KEY `Ref42144` (`msgEventCnfgId`),
  CONSTRAINT `Refdtprvdr_instance86` FOREIGN KEY (`distrListInstanceId`) REFERENCES `dtprvdr_instance` (`id`),
  CONSTRAINT `Refdtprvdr_instance87` FOREIGN KEY (`distrRuleInstanceId`) REFERENCES `dtprvdr_instance` (`id`),
  CONSTRAINT `Refmsg_event_config144` FOREIGN KEY (`msgEventCnfgId`) REFERENCES `msg_event_config` (`id`),
  CONSTRAINT `Refmsg_recipient_type78` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_event_recepient_config` */

/*Table structure for table `msg_event_scope` */

DROP TABLE IF EXISTS `msg_event_scope`;

CREATE TABLE `msg_event_scope` (
  `id` bigint(20) NOT NULL,
  `msgEventCnfgId` bigint(20) DEFAULT NULL,
  `msgScopeParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref42111` (`msgEventCnfgId`),
  KEY `Ref37112` (`msgScopeParamId`),
  CONSTRAINT `Refmsg_event_config111` FOREIGN KEY (`msgEventCnfgId`) REFERENCES `msg_event_config` (`id`),
  CONSTRAINT `Refmsg_scope_param112` FOREIGN KEY (`msgScopeParamId`) REFERENCES `msg_scope_param` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_event_scope` */

/*Table structure for table `msg_event_scope_record` */

DROP TABLE IF EXISTS `msg_event_scope_record`;

CREATE TABLE `msg_event_scope_record` (
  `id` bigint(20) NOT NULL,
  `msgEventScopeId` bigint(20) DEFAULT NULL,
  `recordId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref55113` (`msgEventScopeId`),
  CONSTRAINT `Refmsg_event_scope113` FOREIGN KEY (`msgEventScopeId`) REFERENCES `msg_event_scope` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_event_scope_record` */

/*Table structure for table `msg_inbox` */

DROP TABLE IF EXISTS `msg_inbox`;

CREATE TABLE `msg_inbox` (
  `id` bigint(20) NOT NULL,
  `messageFrom` bigint(20) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `messageBody` blob,
  `createdTime` datetime DEFAULT NULL,
  `messageType` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_inbox` */

/*Table structure for table `msg_log` */

DROP TABLE IF EXISTS `msg_log`;

CREATE TABLE `msg_log` (
  `id` bigint(20) NOT NULL,
  `msgEventCnfgId` bigint(20) DEFAULT NULL,
  `recordCreatedTimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `msgPriority` varchar(50) DEFAULT NULL,
  `statusCode` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref42119` (`msgEventCnfgId`),
  CONSTRAINT `Refmsg_event_config119` FOREIGN KEY (`msgEventCnfgId`) REFERENCES `msg_event_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_log` */

/*Table structure for table `msg_log_context_param` */

DROP TABLE IF EXISTS `msg_log_context_param`;

CREATE TABLE `msg_log_context_param` (
  `id` bigint(20) NOT NULL,
  `msgLogId` bigint(20) DEFAULT NULL,
  `msgScopeParamId` bigint(20) DEFAULT NULL,
  `paramValue` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref61142` (`msgLogId`),
  KEY `Ref37143` (`msgScopeParamId`),
  CONSTRAINT `Refmsg_log142` FOREIGN KEY (`msgLogId`) REFERENCES `msg_log` (`id`),
  CONSTRAINT `Refmsg_scope_param143` FOREIGN KEY (`msgScopeParamId`) REFERENCES `msg_scope_param` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_log_context_param` */

/*Table structure for table `msg_message_type` */

DROP TABLE IF EXISTS `msg_message_type`;

CREATE TABLE `msg_message_type` (
  `id` bigint(20) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_message_type` */

/*Table structure for table `msg_rcpnt_type_log` */

DROP TABLE IF EXISTS `msg_rcpnt_type_log`;

CREATE TABLE `msg_rcpnt_type_log` (
  `id` bigint(20) NOT NULL,
  `msgLogId` bigint(20) DEFAULT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  `msgEventRcpntCnfgId` bigint(20) DEFAULT NULL,
  `statusCode` varchar(50) DEFAULT NULL,
  `totalCount` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref61120` (`msgLogId`),
  KEY `Ref32121` (`recipientTypeId`),
  KEY `Ref43141` (`msgEventRcpntCnfgId`),
  CONSTRAINT `Refmsg_event_recepient_config141` FOREIGN KEY (`msgEventRcpntCnfgId`) REFERENCES `msg_event_recepient_config` (`id`),
  CONSTRAINT `Refmsg_log120` FOREIGN KEY (`msgLogId`) REFERENCES `msg_log` (`id`),
  CONSTRAINT `Refmsg_recipient_type121` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_rcpnt_type_log` */

/*Table structure for table `msg_recipient` */

DROP TABLE IF EXISTS `msg_recipient`;

CREATE TABLE `msg_recipient` (
  `id` bigint(20) NOT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  `messageId` bigint(20) DEFAULT NULL,
  `recipientUserId` bigint(20) DEFAULT NULL,
  `whetherRead` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref32117` (`recipientTypeId`),
  KEY `Ref58149` (`messageId`),
  CONSTRAINT `Refmsg_inbox149` FOREIGN KEY (`messageId`) REFERENCES `msg_inbox` (`id`),
  CONSTRAINT `Refmsg_recipient_type117` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_recipient` */

/*Table structure for table `msg_recipient_log` */

DROP TABLE IF EXISTS `msg_recipient_log`;

CREATE TABLE `msg_recipient_log` (
  `id` bigint(20) NOT NULL,
  `msgRecipientTypeLogId` bigint(20) DEFAULT NULL,
  `systemMsgContact` varchar(50) DEFAULT NULL,
  `emailContact` varchar(50) DEFAULT NULL,
  `smsContact` varchar(50) DEFAULT NULL,
  `emailStatusCode` varchar(50) DEFAULT NULL,
  `smsStatusCode` varchar(50) DEFAULT NULL,
  `systemMsgStatusCode` varchar(50) DEFAULT NULL,
  `letterStatusCode` char(10) DEFAULT NULL,
  `recipientId` bigint(20) DEFAULT NULL,
  `recipientContextData` text,
  PRIMARY KEY (`id`),
  KEY `Ref62150` (`msgRecipientTypeLogId`),
  CONSTRAINT `Refmsg_rcpnt_type_log150` FOREIGN KEY (`msgRecipientTypeLogId`) REFERENCES `msg_rcpnt_type_log` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_recipient_log` */

/*Table structure for table `msg_recipient_type` */

DROP TABLE IF EXISTS `msg_recipient_type`;

CREATE TABLE `msg_recipient_type` (
  `id` bigint(20) NOT NULL,
  `recipientDataProviderId` bigint(20) DEFAULT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref44145` (`recipientDataProviderId`),
  CONSTRAINT `Refdtprovider145` FOREIGN KEY (`recipientDataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_recipient_type` */

/*Table structure for table `msg_scope` */

DROP TABLE IF EXISTS `msg_scope`;

CREATE TABLE `msg_scope` (
  `id` bigint(20) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_scope` */

/*Table structure for table `msg_scope_param` */

DROP TABLE IF EXISTS `msg_scope_param`;

CREATE TABLE `msg_scope_param` (
  `id` bigint(20) NOT NULL,
  `msgScopeId` bigint(20) DEFAULT NULL,
  `messageScopeId` bigint(20) DEFAULT NULL,
  `displayCode` varchar(50) DEFAULT NULL,
  `uiComponentReference` varchar(20) NOT NULL,
  `paramKey` varchar(50) NOT NULL,
  `savedSearchOperandPlaceHolder` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref36128` (`msgScopeId`),
  CONSTRAINT `Refmsg_scope128` FOREIGN KEY (`msgScopeId`) REFERENCES `msg_scope` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_scope_param` */

/*Table structure for table `msg_template` */

DROP TABLE IF EXISTS `msg_template`;

CREATE TABLE `msg_template` (
  `id` bigint(20) NOT NULL,
  `msgTemplateConfigId` bigint(20) DEFAULT NULL,
  `msgDeliveryModeId` bigint(20) DEFAULT NULL,
  `subjectLine` text,
  `msgContent` blob,
  PRIMARY KEY (`id`),
  KEY `Ref3867` (`msgTemplateConfigId`),
  KEY `Ref70146` (`msgDeliveryModeId`),
  CONSTRAINT `Refmsg_delivery_mode146` FOREIGN KEY (`msgDeliveryModeId`) REFERENCES `msg_delivery_mode` (`id`),
  CONSTRAINT `Refmsg_template_config67` FOREIGN KEY (`msgTemplateConfigId`) REFERENCES `msg_template_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_template` */

/*Table structure for table `msg_template_config` */

DROP TABLE IF EXISTS `msg_template_config`;

CREATE TABLE `msg_template_config` (
  `id` bigint(20) NOT NULL,
  `msgSubCatagoryId` bigint(20) DEFAULT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  `msgMessageTypeId` bigint(20) DEFAULT NULL,
  `templateDataProviderId` bigint(20) DEFAULT NULL,
  `templateConfigType` varchar(100) DEFAULT NULL,
  `templateConfigName` varchar(100) NOT NULL,
  `whetherBulkMesaging` bit(1) DEFAULT NULL,
  `approvalRequired` bit(1) DEFAULT NULL,
  `approverId` bigint(20) DEFAULT NULL,
  `whetherStaticMsg` bit(1) DEFAULT NULL,
  `status` bit(1) DEFAULT NULL,
  `availableForAdhocMsg` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3568` (`msgSubCatagoryId`),
  KEY `Ref3269` (`recipientTypeId`),
  KEY `Ref71147` (`msgMessageTypeId`),
  KEY `Ref66148` (`templateDataProviderId`),
  CONSTRAINT `Refmsg_catagory68` FOREIGN KEY (`msgSubCatagoryId`) REFERENCES `msg_catagory` (`id`),
  CONSTRAINT `Refmsg_message_type147` FOREIGN KEY (`msgMessageTypeId`) REFERENCES `msg_message_type` (`id`),
  CONSTRAINT `Refmsg_recipient_type69` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`),
  CONSTRAINT `Reftemplate_dtprovider148` FOREIGN KEY (`templateDataProviderId`) REFERENCES `template_dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `msg_template_config` */

/*Table structure for table `schedule_message_event_log` */

DROP TABLE IF EXISTS `schedule_message_event_log`;

CREATE TABLE `schedule_message_event_log` (
  `id` bigint(20) NOT NULL,
  `systemMsgEventId` bigint(20) DEFAULT NULL,
  `configurationValue` bigint(20) DEFAULT NULL,
  `statusCode` varchar(50) DEFAULT NULL,
  `createdTimeStamp` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref40118` (`systemMsgEventId`),
  CONSTRAINT `Refsystem_msg_event118` FOREIGN KEY (`systemMsgEventId`) REFERENCES `system_msg_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `schedule_message_event_log` */

/*Table structure for table `sys_msg_evt_default_conf` */

DROP TABLE IF EXISTS `sys_msg_evt_default_conf`;

CREATE TABLE `sys_msg_evt_default_conf` (
  `id` bigint(20) NOT NULL,
  `systemMsgEventId` bigint(20) DEFAULT NULL,
  `msgTemplateConfigId` bigint(20) DEFAULT NULL,
  `initiationRuleProviderId` bigint(20) DEFAULT NULL,
  `repeatitionRuleId` bigint(20) DEFAULT NULL,
  `intiationScheduleCronDef` varchar(20) DEFAULT NULL,
  `sendingPriority` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3897` (`msgTemplateConfigId`),
  KEY `Ref4498` (`initiationRuleProviderId`),
  KEY `Ref40138` (`systemMsgEventId`),
  CONSTRAINT `Refdtprovider98` FOREIGN KEY (`initiationRuleProviderId`) REFERENCES `dtprovider` (`id`),
  CONSTRAINT `Refmsg_template_config97` FOREIGN KEY (`msgTemplateConfigId`) REFERENCES `msg_template_config` (`id`),
  CONSTRAINT `Refsystem_msg_event138` FOREIGN KEY (`systemMsgEventId`) REFERENCES `system_msg_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_msg_evt_default_conf` */

/*Table structure for table `sys_msg_evt_default_scope` */

DROP TABLE IF EXISTS `sys_msg_evt_default_scope`;

CREATE TABLE `sys_msg_evt_default_scope` (
  `id` bigint(20) NOT NULL,
  `sysMsgEvtDefaultCnfgId` bigint(20) DEFAULT NULL,
  `msgScopeParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref5199` (`sysMsgEvtDefaultCnfgId`),
  KEY `Ref37100` (`msgScopeParamId`),
  CONSTRAINT `Refmsg_scope_param100` FOREIGN KEY (`msgScopeParamId`) REFERENCES `msg_scope_param` (`id`),
  CONSTRAINT `Refsys_msg_evt_default_conf99` FOREIGN KEY (`sysMsgEvtDefaultCnfgId`) REFERENCES `sys_msg_evt_default_conf` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_msg_evt_default_scope` */

/*Table structure for table `sys_msg_evtrcpt_default_conf` */

DROP TABLE IF EXISTS `sys_msg_evtrcpt_default_conf`;

CREATE TABLE `sys_msg_evtrcpt_default_conf` (
  `id` bigint(20) NOT NULL,
  `sysMsgEvtDefaultConfId` bigint(20) DEFAULT NULL,
  `distrListProviderId` bigint(20) DEFAULT NULL,
  `distrRuleProviderId` bigint(20) DEFAULT NULL,
  `recipientTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref51101` (`sysMsgEvtDefaultConfId`),
  KEY `Ref44103` (`distrListProviderId`),
  KEY `Ref44104` (`distrRuleProviderId`),
  KEY `Ref32130` (`recipientTypeId`),
  CONSTRAINT `Refdtprovider103` FOREIGN KEY (`distrListProviderId`) REFERENCES `dtprovider` (`id`),
  CONSTRAINT `Refdtprovider104` FOREIGN KEY (`distrRuleProviderId`) REFERENCES `dtprovider` (`id`),
  CONSTRAINT `Refmsg_recipient_type130` FOREIGN KEY (`recipientTypeId`) REFERENCES `msg_recipient_type` (`id`),
  CONSTRAINT `Refsys_msg_evt_default_conf101` FOREIGN KEY (`sysMsgEvtDefaultConfId`) REFERENCES `sys_msg_evt_default_conf` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_msg_evtrcpt_default_conf` */

/*Table structure for table `system_msg_event` */

DROP TABLE IF EXISTS `system_msg_event`;

CREATE TABLE `system_msg_event` (
  `id` bigint(20) NOT NULL,
  `msgConfigLevelId` bigint(20) DEFAULT NULL,
  `messsageSubCatagoryId` bigint(20) DEFAULT NULL,
  `msgSubCatagoryId` bigint(20) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `displayCode` varchar(50) DEFAULT NULL,
  `eventType` varchar(50) DEFAULT NULL,
  `whetherRepetationApplicable` bit(1) DEFAULT NULL,
  `whetherInitiationRuleApplicable` bit(1) DEFAULT NULL,
  `whetherScheduledEvent` bit(1) DEFAULT NULL,
  `whetherMsgScopeApplicable` bit(1) DEFAULT NULL,
  `whetherImplicitDistributionList` bit(1) DEFAULT NULL,
  `whetherDistributionRuleApplicable` bit(1) DEFAULT NULL,
  `whetherCommonMsgTemplate` bit(1) DEFAULT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref3371` (`msgConfigLevelId`),
  KEY `Ref35129` (`msgSubCatagoryId`),
  CONSTRAINT `Refmsg_catagory129` FOREIGN KEY (`msgSubCatagoryId`) REFERENCES `msg_catagory` (`id`),
  CONSTRAINT `Refmsg_config_level71` FOREIGN KEY (`msgConfigLevelId`) REFERENCES `msg_config_level` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_msg_event` */

/*Table structure for table `system_msg_event_config` */

DROP TABLE IF EXISTS `system_msg_event_config`;

CREATE TABLE `system_msg_event_config` (
  `systemMsgEventId` bigint(20) DEFAULT NULL,
  `msgEventCnfgId` bigint(20) DEFAULT NULL,
  `initiationRuleInstanceId` bigint(20) DEFAULT NULL,
  `whetherEnabled` bit(1) DEFAULT NULL,
  `intiationScheduleCronDef` varchar(20) DEFAULT NULL,
  `initiationScheduleMetaData` varchar(255) DEFAULT NULL,
  `repeatitionRuleId` bigint(20) DEFAULT NULL,
  KEY `Ref4089` (`systemMsgEventId`),
  KEY `Ref4290` (`msgEventCnfgId`),
  KEY `Ref4892` (`initiationRuleInstanceId`),
  CONSTRAINT `Refdtprvdr_instance92` FOREIGN KEY (`initiationRuleInstanceId`) REFERENCES `dtprvdr_instance` (`id`),
  CONSTRAINT `Refmsg_event_config90` FOREIGN KEY (`msgEventCnfgId`) REFERENCES `msg_event_config` (`id`),
  CONSTRAINT `Refsystem_msg_event89` FOREIGN KEY (`systemMsgEventId`) REFERENCES `system_msg_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_msg_event_config` */

/*Table structure for table `system_msg_event_param` */

DROP TABLE IF EXISTS `system_msg_event_param`;

CREATE TABLE `system_msg_event_param` (
  `id` bigint(20) NOT NULL,
  `systemMsgEventId` bigint(20) DEFAULT NULL,
  `msgScopeParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref40152` (`systemMsgEventId`),
  KEY `Ref37153` (`msgScopeParamId`),
  CONSTRAINT `Refmsg_scope_param153` FOREIGN KEY (`msgScopeParamId`) REFERENCES `msg_scope_param` (`id`),
  CONSTRAINT `Refsystem_msg_event152` FOREIGN KEY (`systemMsgEventId`) REFERENCES `system_msg_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_msg_event_param` */

/*Table structure for table `template_dtprovider` */

DROP TABLE IF EXISTS `template_dtprovider`;

CREATE TABLE `template_dtprovider` (
  `id` bigint(20) NOT NULL,
  `dataProviderId` bigint(20) DEFAULT NULL,
  `dataProviderName` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref44132` (`dataProviderId`),
  CONSTRAINT `Refdtprovider132` FOREIGN KEY (`dataProviderId`) REFERENCES `dtprovider` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `template_dtprovider` */

/*Table structure for table `user_triggered_msg_evt_log` */

DROP TABLE IF EXISTS `user_triggered_msg_evt_log`;

CREATE TABLE `user_triggered_msg_evt_log` (
  `id` bigint(20) NOT NULL,
  `systemMsgEventId` bigint(20) DEFAULT NULL,
  `contextRecordId` bigint(20) DEFAULT NULL,
  `statusCode` varchar(50) DEFAULT NULL,
  `createdTimeStamp` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref40156` (`systemMsgEventId`),
  CONSTRAINT `Refsystem_msg_event156` FOREIGN KEY (`systemMsgEventId`) REFERENCES `system_msg_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET FOREIGN_KEY_CHECKS=1;