CREATE TABLE `import_utility_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `screenName` varchar(70) NOT NULL,
  `fileDirectory` varchar(255) NOT NULL,
  `code` varchar(45) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_import_utility_master_userid_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_import_utility_master_userid` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `import_utility_uploaded_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `importUtilityMasterId` bigint(20) NOT NULL,
  `fileName` varchar(255) NOT NULL,
  `importedOn` timestamp NULL DEFAULT NULL,
  `processedOn` timestamp NULL DEFAULT NULL,
  `importStatus` varchar(45) NOT NULL,
  `filePath` varchar(255) NOT NULL,
  `errorFilePath` varchar(255) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_import_utility_uploaded_file_usrid_idx` (`lastUpdatedBy`),
  KEY `fk_import_utility_uploaded_file_masterid_idx` (`importUtilityMasterId`),
  CONSTRAINT `fk_import_utility_uploaded_file_masterid` FOREIGN KEY (`importUtilityMasterId`) REFERENCES `import_utility_master` (`id`),
  CONSTRAINT `fk_import_utility_uploaded_file_usrid` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;