CREATE TABLE `marksheet_template_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `templateType` varchar(75) DEFAULT NULL,
  `type` varchar(75) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
   PRIMARY KEY (`id`),
   INDEX `fk_marksheet_template_type_1_idx` (`lastUpdatedBy` ASC),
   CONSTRAINT `fk_marksheet_template_type_1`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);


ALTER TABLE `marksheetJob` 
ADD COLUMN `templateId` BIGINT(20) NULL DEFAULT NULL AFTER `jobId`, RENAME TO `marksheet_job`, 
add INDEX `fk_marksheet_Job_11_idx` (`templateId` ASC),
add CONSTRAINT `fk_marksheet_Job_1`
  FOREIGN KEY (`templateId`)
  REFERENCES `marksheet_template_type` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
add INDEX `fk_marksheet_Job_2_idx` (`lastUpdatedBy` ASC),
add CONSTRAINT `fk_marksheet_Job_2`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


CREATE TABLE `marksheet_job_variant_levels` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseVariantId` BIGINT(20) NULL DEFAULT NULL,
  `evaluationPlanId` BIGINT(20) NULL DEFAULT NULL,
  `evaluationPlanLevelOneId` BIGINT(20) NULL DEFAULT NULL,
  `evaluationPlanLevelTwoId` BIGINT(20) NULL DEFAULT NULL,
  `evaluationSequenceId` BIGINT(20) NULL DEFAULT NULL,
  `marksheetJobId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_marksheet_job_variant_levels_1_idx` (`courseVariantId` ASC),
  INDEX `fk_marksheet_job_variant_levels_2_idx` (`evaluationPlanId` ASC),
  INDEX `fk_marksheet_job_variant_levels_3_idx` (`evaluationPlanLevelOneId` ASC),
  INDEX `fk_marksheet_job_variant_levels_4_idx` (`evaluationPlanLevelTwoId` ASC),
  INDEX `fk_marksheet_job_variant_levels_5_idx` (`evaluationSequenceId` ASC),
  INDEX `fk_marksheet_job_variant_levels_6_idx` (`marksheetJobId` ASC),
  INDEX `fk_marksheet_job_variant_levels_7_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_marksheet_job_variant_levels_1`
    FOREIGN KEY (`courseVariantId`)
    REFERENCES `course_variants` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_2`
    FOREIGN KEY (`evaluationPlanId`)
    REFERENCES `evaluation_plan` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_3`
    FOREIGN KEY (`evaluationPlanLevelOneId`)
    REFERENCES `evaluation_plan_level_one` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_4`
    FOREIGN KEY (`evaluationPlanLevelTwoId`)
    REFERENCES `evaluation_plan_level_two` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_5`
    FOREIGN KEY (`evaluationSequenceId`)
    REFERENCES `evaluation_sequence` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_6`
    FOREIGN KEY (`marksheetJobId`)
    REFERENCES `marksheet_job` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_variant_levels_7`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

    ALTER TABLE `marksheet_job_details` 
DROP FOREIGN KEY `fk_marksheet_job_details_1`;
ALTER TABLE `marksheet_job_details` ADD CONSTRAINT `fk_marksheet_job_details_1`
  FOREIGN KEY (`marksheetJobId`)
  REFERENCES `marksheet_job` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
