set foreign_key_checks=0;

ALTER TABLE `scholarship_academy_locations`   
  CHANGE `academyLocationId` `academyLocationId` BIGINT(20) NOT NULL,
  ADD COLUMN `lastUpdatedBy` BIGINT(20) NOT NULL AFTER `academyLocationId`,
  ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL AFTER `lastUpdatedBy`,
  ADD CONSTRAINT `RefUsers_ScholarshipAcademyLocations` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  
ALTER TABLE `scholarship_programs`   
  DROP COLUMN `scholarshipId`, 
  ADD COLUMN `scholarshipAcademyLocationId` BIGINT(20) NOT NULL AFTER `programId`, 
  DROP INDEX `Refscholarship1925`,
  DROP FOREIGN KEY `Refscholarship1925`,
  ADD CONSTRAINT `ScholarshipAL_ScholarshipProgram` FOREIGN KEY (`scholarshipAcademyLocationId`) REFERENCES `scholarship_academy_locations`(`id`);


ALTER TABLE `scholarship_batches`   
  DROP COLUMN `scholarshipId`, 
  ADD COLUMN `scholarshipProgramId` BIGINT(20) NOT NULL AFTER `id`, 
  DROP INDEX `Refscholarship2167`,
  DROP FOREIGN KEY `Refscholarship2167`,
  ADD CONSTRAINT `RefScholarshipBatch_SProgramId` FOREIGN KEY (`scholarshipProgramId`) REFERENCES `scholarship_programs`(`id`);
  
ALTER TABLE `scholarship_courses`   
  DROP COLUMN `scholarshipId`, 
  ADD COLUMN `scholarshipProgramId` BIGINT(20) NOT NULL AFTER `id`, 
  DROP INDEX `Refscholarship1926`,
  DROP FOREIGN KEY `Refscholarship1926`,
  ADD CONSTRAINT `RefScholarshipCourse_ScholarshipProgramId` FOREIGN KEY (`scholarshipProgramId`) REFERENCES `scholarship_programs`(`id`);
  
  set foreign_key_checks=1;
