
DROP TABLE IF EXISTS route_stops;
DROP TABLE IF EXISTS route;
DROP TABLE IF EXISTS route_location;


-- Route location
CREATE TABLE `trans_route_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locationCode` varchar(45) DEFAULT NULL,
  `locationName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- route
CREATE TABLE `trans_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `routeName` varchar(60) NOT NULL,
  `responsiblePersonId` bigint(20) DEFAULT NULL,
  `responsiblePersonName` varchar(100) DEFAULT NULL,
  `startLocation` bigint(20) DEFAULT NULL,
  `endLocation` bigint(20) DEFAULT NULL,
  `whetherRoundTrip` bit(1) DEFAULT NULL,
  `distance` double(10,2) DEFAULT NULL,
  `whetherActive` bit(1) DEFAULT NULL,
  `routeBillType` varchar(45) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `droolsAgenda` varchar(100) CHARACTER SET big5 DEFAULT NULL,
  `droolsRuleRemarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefResponsiblePerson_idx` (`responsiblePersonId`),
  KEY `RefStartLocation_idx` (`startLocation`),
  KEY `RefEndLocation_idx` (`endLocation`),
  KEY `RefRouteLastUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefEndLocation` FOREIGN KEY (`endLocation`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefResponsiblePerson` FOREIGN KEY (`responsiblePersonId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRouteLastUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStartLocation` FOREIGN KEY (`startLocation`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- route stops

CREATE TABLE `trans_route_stops` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `routeId` bigint(20) NOT NULL,
  `stopLocationId` BIGINT(20) NOT NULL,
  `routeStopType` varchar(100) DEFAULT NULL,
  `stopSeqOnward` int(11) DEFAULT NULL,
  `stopSeqReturn` int(11) DEFAULT NULL,
  `distanceOnward` double(10,2) DEFAULT NULL,
  `distanceReturn` double(10,2) DEFAULT NULL,
  `whetherActive` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRouteId23_idx` (`routeId`),
  KEY `RefStopLocationId24_idx` (`stopLocationId`),
  KEY `RefStopUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefRouteId23` FOREIGN KEY (`routeId`) REFERENCES `trans_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStopLocationId24_idx` FOREIGN KEY (`stopLocationId`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStopUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`whetherChild`,`whetherParent`,
`droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1,NULL,'trans_route_location','TRANS_ROUTE_LOCATION','Transport','\0','\0',NULL,1,@currentTimeStamp);

SELECT * FROM standard_master_items;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'locationCode', 'LOCATION_CODE', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

SELECT * FROM standard_master_items;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'locationName', 'LOCATION_NAME', @standardMasterMaxId + 1, 'varchar', '2', 0, 0, 0, 1, '1', SYSDATE());
 