CREATE TABLE `bill_header_tracking` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `raiseBillType` varchar(150) DEFAULT NULL,
  `raiseBillCategory` varchar(150) DEFAULT NULL,
  `raiseBillFor` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `totalAmount` double(20,2) DEFAULT NULL,
  `billNo` varchar(200) NOT NULL,
  `billUniqueNumber` int(20) DEFAULT NULL,
  `billingDate` date DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `reasonForManualBill` text,
  `iauId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `approver` bigint(20) DEFAULT NULL,
  `approvalDate` date DEFAULT NULL,
  `billStatus` varchar(200) DEFAULT 'FULLY_PENDING',
  `refundReason` bigint(20) DEFAULT NULL,
  `billGenerationType` varchar(45) DEFAULT 'MANUAL',
  `studentId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `defaultIAU` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `voucherStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefusersTracking` (`lastUpdatedBy`),
  KEY `RefSponsorTracking_idx` (`sponsorId`),
  KEY `RefapplicationTracking_idx` (`applicantId`),
  KEY `RefcurrencyTracking_idx` (`currencyId`),
  KEY `ReffeethirdpartiesTracking_idx` (`thirdPartyId`),
  KEY `ReforganizationunitsTracking_idx` (`iauId`),
  KEY `RefuserTracking_idx` (`userId`),
  KEY `RefundReasonTracking_idx` (`refundReason`),
  KEY `RefapproverTracking_idx` (`approver`),
  KEY `RefBilledusertypeTracking_idx` (`raiseBillFor`),
  KEY `RefstudentTracking_idx` (`studentId`),
  KEY `RefServiceReqTracking_idx` (`serviceRequestId`),
  KEY `RefscholarshipTracking_idx` (`scholarshipId`),
  KEY `RefIAUTracking_idx` (`defaultIAU`),
  KEY `RefAcademyLocationTracking_idx` (`academyLocationId`),
  CONSTRAINT `RefAcademyLocationTracking` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefapplicationTracking` FOREIGN KEY (`applicantId`) REFERENCES `application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefapproverTracking` FOREIGN KEY (`approver`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefBilledusertypeTracking` FOREIGN KEY (`raiseBillFor`) REFERENCES `billed_user_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefcurrencyTracking` FOREIGN KEY (`currencyId`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `ReffeethirdpartiesTracking` FOREIGN KEY (`thirdPartyId`) REFERENCES `fee_third_parties` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefIAUTracking` FOREIGN KEY (`defaultIAU`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `ReforganizationunitsTracking` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefscholarshipTracking` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefServiceReqTracking` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefSponsorTracking` FOREIGN KEY (`sponsorId`) REFERENCES `sponsors` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefstudentTracking` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefundReasonTracking` FOREIGN KEY (`refundReason`) REFERENCES `refund_reasons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefusersTracking` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `RefuserTracking` FOREIGN KEY (`userId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



CREATE TABLE `bill_fee_plan_rule_stage_tracking` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `billId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `feeAmount` double(20,2) DEFAULT NULL,
  `discountAmount` double(20,2) DEFAULT NULL,
  `billableAmount` double(20,2) DEFAULT NULL,
  `adjustedAmount` double(20,2) DEFAULT NULL,
  `balanceAmount` double(20,2) DEFAULT NULL,
  `concessionAmount` double(20,2) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `sponsorshipInstallmentId` bigint(20) DEFAULT NULL,
  `feePlanSubmissionScheduleId` bigint(20) DEFAULT NULL,
  `installmentRef` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refbill_header1619` (`billId`),
  KEY `Refusers11226` (`lastUpdatedBy`),
  KEY `Reffee_stage_head_config11521` (`feeStageHeadConfigId`),
  KEY `Refscholarship11247_idx` (`scholarshipId`),
  KEY `installmentRef1` (`installmentRef`),
  KEY `RefSponsorShipInstallment1123_idx` (`sponsorshipInstallmentId`),
  KEY `FK636773E0898411941` (`studentId`),
  KEY `RefFeePlanSubmissionSchedue112345` (`feePlanSubmissionScheduleId`),
  CONSTRAINT `bill_fee_plan_rule_stage_ibfk_11` FOREIGN KEY (`studentId`) REFERENCES `users` (`id`),
  CONSTRAINT `bill_fee_plan_rule_stage_ibfk_12` FOREIGN KEY (`installmentRef`) REFERENCES `installment_details` (`id`),
  CONSTRAINT `FK636773E0898411941` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `Refbill_header1619` FOREIGN KEY (`billId`) REFERENCES `bill_header_tracking` (`id`),
  CONSTRAINT `RefFeePlanSubmissionSchedue112345` FOREIGN KEY (`feePlanSubmissionScheduleId`) REFERENCES `fee_plan_submission_sch` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffee_stage_head_config11521` FOREIGN KEY (`feeStageHeadConfigId`) REFERENCES `fee_stage_head_config` (`id`),
  CONSTRAINT `Refscholarship11247` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefSponsorShipInstallment1123` FOREIGN KEY (`sponsorshipInstallmentId`) REFERENCES `sponsorship_installments` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers11226` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `bill_dependant_details_tracking` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `billId` bigint(20) DEFAULT NULL,
  `billFeePlanRuleStageId` bigint(20) DEFAULT NULL,
  `dependantFeeHeadId` bigint(20) DEFAULT NULL,
  `feeAmount` double(20,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refuser1768_idx` (`lastUpdatedBy`),
  KEY `Refbillheader15464_idx` (`billId`),
  KEY `refBillFeePlanRuleStage13241_idx` (`billFeePlanRuleStageId`),
  KEY `RefFeeDepedentHeadConfig11245_idx` (`dependantFeeHeadId`),
  CONSTRAINT `refBillFeePlanRuleStage13241` FOREIGN KEY (`billFeePlanRuleStageId`) REFERENCES `bill_fee_plan_rule_stage_tracking` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refbillheader15464` FOREIGN KEY (`billId`) REFERENCES `bill_header_tracking` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefFeeDepedentHeadConfig11245` FOREIGN KEY (`dependantFeeHeadId`) REFERENCES `fee_dependant_head_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuser1768` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
