-- invt_type_master
CREATE TABLE `invt_type_master`( `id` BIGINT(20) NOT NULL, `inventoryType` VARCHAR(255), `lastUpdatedBy` BIGINT(20) NOT NULL, `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`), CONSTRAINT `Refusers1553` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 

ALTER TABLE `invt_type_master` CHANGE `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT; 

-- invt_publisher_master

CREATE TABLE `invt_publisher_master`( `id` BIGINT(20) NOT NULL AUTO_INCREMENT, `publisherName` VARCHAR(255) NOT NULL, `lastUpdatedBy` BIGINT(20) NOT NULL, `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 

ALTER TABLE `invt_publisher_master` ADD CONSTRAINT `Refusers1554` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`); 

INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES ('invt_type_master', 'INVT_TYPE_MASTER', 'Program & Courses', 0, 0, '1', SYSDATE());


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('inventoryType', 'INVENTORY TYPE', @standardMasterMaxId, 'Varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES ('invt_publisher_master', 'INVT_PUBLISHER_MASTER', 'Program & Courses', 0, 0, '1', SYSDATE());


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, 
`whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('publisherName', 'PUBLISHER NAME', @standardMasterMaxId, 'Varchar', '1', 0, 0, 0, 1, '1', SYSDATE());



-- invt_item_master

CREATE TABLE `invt_item_master`( `id` BIGINT(20) NOT NULL AUTO_INCREMENT, `inventoryTypeId` BIGINT(20) NOT NULL, `inventoryItemName` VARCHAR(255) NOT NULL, `firstAuthorName` VARCHAR(255) NOT NULL, `otherAuthorName` VARCHAR(255), `publisherId` BIGINT(20), `edition` VARCHAR(255), `volume` VARCHAR(255), `remarks` TEXT, `lastUpdatedBy` BIGINT(20) NOT NULL, `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`), CONSTRAINT `Reffpublisher` FOREIGN KEY (`publisherId`) REFERENCES `invt_publisher_master`(`id`), CONSTRAINT `ReffUser12` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ); 

-- invt_item_master_detail
CREATE TABLE `invt_item_master_detail`( `id` BIGINT(20) NOT NULL AUTO_INCREMENT, `inventoryItemId` BIGINT(20) NOT NULL, `academyLocationId` BIGINT(20), `quntity` INT, `vendorName` VARCHAR(255), `purchaseDate` DATE, `invtItemCondition` VARCHAR(50), `remarks` TEXT, `lastUpdatedBy` BIGINT(20), `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`), CONSTRAINT `invtItemId` FOREIGN KEY (`inventoryItemId`) REFERENCES `invt_item_master`(`id`), CONSTRAINT `academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`), CONSTRAINT `lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 

CREATE TABLE `invt_item_master_cd`( `id` BIGINT(20) NOT NULL, `invtItemMasterId` BIGINT(20), `cf1` VARCHAR(255), `cf2` VARCHAR(255), `cf3` VARCHAR(255), `cf4` VARCHAR(255), `cf5` VARCHAR(255), `cf6` VARCHAR(255), `cf7` VARCHAR(255), `cf8` VARCHAR(255), `cf9` VARCHAR(255), `cf10` VARCHAR(255), `cf11` BIGINT(20), `cf12` BIGINT(20), `cf13` BIGINT(20), `cf14` DATE, `cf15` DATE, `cf16` TINYINT(1), `cf17` TINYINT(1), `cf18` VARCHAR(255), `cf19` VARCHAR(255), `lastUpdatedBy` BIGINT(20), `lastUpdate` DATETIME, PRIMARY KEY (`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 

ALTER TABLE `invt_item_master_cd` ADD COLUMN `version` BIGINT(20) NULL AFTER `lastUpdate`; 
