drop view if exists `student_course_enrollment_search`;

CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `student_course_enrollment_search` AS
    select 
		ROUND(RAND() * 10000) as 'id',
        g.id as 'programId',
        g.programName as 'programName',
        f.id as 'batchId',
        f.batchName as 'batchName',
        if(b.id is null, - 1, b.id) as 'periodId',
        if(b.id is null,
            '-',
            b.programPeriodName) as 'periodName',
        if(e.id is null, - 1, e.id) as 'courseVariantId',
        if(e.id is null,
            '-',
            e.courseVariantCode) as 'courseVariantCode',
        h.id as 'courseId',
        h.courseCode as 'courseName',
        a.id as 'sectionId',
        a.sectionCode as 'sectionCode',
        d.whetherOptional as 'courseType',
        h.assignSectionType as 'sectionType'
    from
        sections a
            left join
        prog_batch_period_config b ON b.id = a.periodId
            right join
        batch_courses c ON c.batchId = b.programBatchId
            left join
        program_batch_course_param d ON (d.sectionId = a.id
            and d.courseId = c.courseId)
            left join
        course_variants e ON e.id = d.courseVarientId
            left join
        batches f ON f.id = b.programBatchId
            left join
        programs g ON g.id = f.programId
            left join
        courses h ON h.id = c.courseId 
    UNION ALL select 
		ROUND(RAND() * 10000) as 'id',
        f.id as 'programId',
        f.programName as 'programName',
        e.id as 'batchId',
        e.batchName as 'batchName',
        if(d.id is null, - 1, d.id) as 'periodId',
        if(d.id is null,
            '-',
            d.programPeriodName) as 'periodName',
        if(b.id is null, - 1, b.id) as 'courseVariantId',
        if(b.id is null,
            '-',
            b.courseVariantCode) as 'courseVariantCode',
        g.id as 'courseId',
        g.courseCode as 'courseName',
        a.id as 'sectionId',
        a.sectionCode as 'sectionCode',
        c.whetherOptional as 'courseType',
        g.assignSectionType as 'sectionType'
    from
        sections a
            left join
        course_variants b ON (b.id = a.courseVariantId)
            left join
        program_batch_course_param c ON (c.courseVarientId = b.id)
            left join
        prog_batch_period_config d ON (c.progBatchPeriodConfigId = d.id)
            left join
        batches e ON (e.id = d.programBatchId)
            left join
        programs f ON (f.id = e.programId)
            left join
        courses g ON (g.id = b.courseId);