

SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `evaluation_type_program` 
ADD COLUMN `eligibleForRankCalculation` BIT(1) NULL DEFAULT b'0' AFTER `completionStatus`,
CHANGE COLUMN `lastUpdate` `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
ADD UNIQUE INDEX `period_section_unique_type_program` (`evaluationPlanId` ASC, `programBatchPeriodConfigId` ASC, `sectionId` ASC);
SET FOREIGN_KEY_CHECKS=1;


ALTER TABLE `evaluation_type_course` 
CHANGE COLUMN `isLongDistance` `isLongDistance` BIT(1) NULL DEFAULT b'0' AFTER `completionStatus`,
CHANGE COLUMN `lastUpdate` `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
ADD COLUMN `eligibleForRankCalculation` BIT(1) NULL DEFAULT b'0' AFTER `isLongDistance`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD INDEX `fk_evaluation_type_course_1_idx` (`sectionId` ASC),
ADD UNIQUE INDEX `plan_variant_section_unique_type` (`courseVariantId` ASC, `sectionId` ASC);
ALTER TABLE `evaluation_type_course` 
ADD CONSTRAINT `fk_evaluation_type_course_1`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  
  
  
  CREATE TABLE `evaluation_plan_courses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `isPrimaryCourse` bit(1) DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `plan_course_unique_map` (`evaluationPlanId` ASC, `courseId` ASC),
  KEY `evaluation_plan_courses_fk1` (`evaluationPlanId`),
  KEY `evaluation_plan_courses_fk2` (`lastUpdatedBy`),
  KEY `evaluation_plan_courses_fk3` (`courseId`),
  CONSTRAINT `evaluation_plan_courses_fk1` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `evaluation_plan_courses_fk2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `evaluation_plan_courses_fk3` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `examination_result` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `courseRank` INT(11) NULL DEFAULT NULL AFTER `gradePoints`;

ALTER TABLE `evaluation_sequence_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `courseRank` INT(11) NULL DEFAULT NULL AFTER `courseVariantId`;

ALTER TABLE `evaluation_plan_level_two_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `courseRank` INT(11) NULL DEFAULT NULL AFTER `courseVariantId`;

ALTER TABLE `evaluation_plan_level_one_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `courseRank` INT(11) NULL DEFAULT NULL AFTER `courseVariantId`;

ALTER TABLE `evaluation_plan_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `courseRank` INT(11) NULL DEFAULT NULL AFTER `courseVariantId`;

ALTER TABLE `evaluation_period_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `periodRank` INT(11) NULL DEFAULT NULL AFTER `admissionId`;

ALTER TABLE `evaluation_program_rank` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `programRank` INT(11) NULL DEFAULT NULL AFTER `admissionId`;

ALTER TABLE `marksheet` 
CHANGE COLUMN `rank` `sectionRank` INT(11) NULL DEFAULT NULL ,
ADD COLUMN `levelRank` INT(11) NULL DEFAULT NULL AFTER `effectiveMarks`;

