CREATE 
   OR REPLACE
VIEW `fee_dashboard_collection_headwise_all` AS
    SELECT 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                        SUM(`fee_adjustment_details`.`adjustedAmount`)
                    FROM
                        ((((((((((((((((((((`fee_adjustment_details`
                        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        LEFT JOIN `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        LEFT JOIN `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        LEFT JOIN `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        LEFT JOIN `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        LEFT JOIN `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            AND (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        LEFT JOIN `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    WHERE
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` = `students`.`userId`)
                            AND (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                        SUM(`fee_adjustment_details`.`adjustedAmount`)
                    FROM
                        ((((((((((((((((((((`fee_adjustment_details`
                        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        LEFT JOIN `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        LEFT JOIN `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        LEFT JOIN `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        LEFT JOIN `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        LEFT JOIN `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            AND (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        LEFT JOIN `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    WHERE
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` = `students`.`userId`)
                            AND (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    FROM
        (((((((((((((((((((((`fee_adjustment_details`
        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        LEFT JOIN `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        LEFT JOIN `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        LEFT JOIN `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        LEFT JOIN `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        LEFT JOIN `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        LEFT JOIN `persons` ON ((`students`.`personId` = `persons`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            AND (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    WHERE
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ISNULL(`receipt_header`.`applicantId`)
            AND (`fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')))
    HAVING (`receivedAmount` > 0);


CREATE 
   OR REPLACE
VIEW `fee_dashboard_collection_headwise_application` AS
    SELECT 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                        `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        ((((((((((((((`fee_adjustment_details`
                        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        LEFT JOIN `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        LEFT JOIN `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        LEFT JOIN `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        LEFT JOIN `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            AND (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    WHERE
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` = `application`.`id`)
                            AND (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                        `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        ((((((((((((((`fee_adjustment_details`
                        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        LEFT JOIN `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        LEFT JOIN `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        LEFT JOIN `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        LEFT JOIN `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            AND (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    WHERE
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` = `application`.`id`)
                            AND (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`
    FROM
        (((((((((((((((((((((`fee_adjustment_details`
        LEFT JOIN `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        LEFT JOIN `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        LEFT JOIN `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        LEFT JOIN `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        LEFT JOIN `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        LEFT JOIN `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        LEFT JOIN `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        LEFT JOIN `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            AND (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    WHERE
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND (`fee_plan_type`.`feePlanType` IN ('Application' , 'Program')))
    HAVING (`receivedAmount` > 0);


