

CREATE TABLE `hr_employee_attribute_master` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `attributeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, 
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'SQL/ENUM', 
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'table name/ enum name', 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_employee_attribute_master_1_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_employee_attribute_master_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

ALTER TABLE `hr_eligibility_leave_type` 
ADD COLUMN `employeeAttributeMasterId` BIGINT(20) NULL DEFAULT NULL AFTER `leaveTypeId`,
ADD INDEX `fk_hr_eligibility_setting_leave_type_4_idx` (`employeeAttributeMasterId` ASC);
ALTER TABLE `hr_eligibility_leave_type` 
ADD CONSTRAINT `fk_hr_eligibility_setting_leave_type_4`
  FOREIGN KEY (`employeeAttributeMasterId`)
  REFERENCES `hr_employee_attribute_master` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

CREATE TABLE `hr_sanctioning_setting` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `sanctioningCode` varchar(255) DEFAULT NULL, 
  `maxApplicationDays` double(10,2) DEFAULT NULL, 
  `minApplicationDays` double(10,2) DEFAULT NULL, 
  `maxSanctioningPeriod` varchar(45) DEFAULT NULL, 
  `maxTimesToSanction` double(10,2) DEFAULT NULL, 
  `maxLeavesToSanction` double(10,2) DEFAULT NULL, 
  `daysForAdvanceApplication` varchar(45) DEFAULT NULL, 
  `daysBeforeEvent` varchar(45) DEFAULT NULL, 
  `daysAfterEvent` varchar(45) DEFAULT NULL, 
  `isHolidayCheck` bit(1) DEFAULT NULL, 
  `isCombinable` bit(1) DEFAULT NULL, 
  `otherSanctioningCriteria` varchar(45) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_sanctioning_setting_1_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_sanctioning_setting_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 


CREATE TABLE `hr_sanctioning_leave_type` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `sanctioningSettingId` bigint(20) DEFAULT NULL, 
  `eligibilityCtiteria` varchar(45) DEFAULT NULL, 
  `leaveTypeId` bigint(20) DEFAULT NULL, 
  `employeeAttributeType` varchar(45) DEFAULT NULL, 
  `employeeAttributeValue` varchar(45) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_sanctioning_leave_type_1_idx` (`sanctioningSettingId`), 
  KEY `fk_hr_sanctioning_leave_type_2_idx` (`leaveTypeId`), 
  KEY `fk_hr_sanctioning_leave_type_3_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_sanctioning_leave_type_1` FOREIGN KEY (`sanctioningSettingId`) REFERENCES `hr_sanctioning_setting` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_leave_type_2` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_leave_type_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 




CREATE TABLE `hr_sanctioning_combine_leave_type` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `sanctioningSettingId` bigint(20) DEFAULT NULL, 
  `leaveTypeId` bigint(20) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_sanctioning_combine_leave_type_1_idx` (`sanctioningSettingId`), 
  KEY `fk_hr_sanctioning_combine_leave_type_2_idx` (`leaveTypeId`), 
  KEY `fk_hr_sanctioning_combine_leave_type_3_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_sanctioning_combine_leave_type_1` FOREIGN KEY (`sanctioningSettingId`) REFERENCES `hr_sanctioning_setting` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_combine_leave_type_2` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_combine_leave_type_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 


CREATE TABLE `hr_sanctioning_leave_type_al` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `sanctioningLeaveTypeId` bigint(20) DEFAULT NULL, 
  `academyLocationId` bigint(20) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_sanctioning_leave_type_al_1_idx` (`sanctioningLeaveTypeId`), 
  KEY `fk_hr_sanctioning_leave_type_al_2_idx` (`academyLocationId`), 
  KEY `fk_hr_sanctioning_leave_type_al_3_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_sanctioning_leave_type_al_1` FOREIGN KEY (`sanctioningLeaveTypeId`) REFERENCES `hr_sanctioning_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_leave_type_al_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_sanctioning_leave_type_al_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 

CREATE TABLE `hr_administration_setting` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `administrationCode` varchar(255)  DEFAULT NULL, 
  `leaveBalanceFlag` varchar(45)  DEFAULT NULL, 
  `leaveBalanceUpdatePeriod` varchar(45)  DEFAULT NULL, 
  `isLimitLeavesToBalance` bit(1) DEFAULT NULL, 
  `maxLeavesCarryForward` double(10,1) DEFAULT NULL, 
  `maxLeaveBalance` double(10,1) DEFAULT NULL, 
  `isEncashExcessLeaves` bit(1) DEFAULT NULL, 
  `minDaysToEncash` double(10,1) DEFAULT NULL, 
  `minBalanceForEncashment` double(10,1) DEFAULT NULL, 
  `balanceAfterEncashment` double(10,1) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_administration_setting_1_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_administration_setting_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 


CREATE TABLE `hr_administration_leave_type` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `administrationSettingsId` bigint(20) DEFAULT NULL, 
  `eligibilityCtiteria` varchar(45) DEFAULT NULL, 
  `leaveTypeId` bigint(20) DEFAULT NULL, 
  `employeeAttributeMasterId` bigint(20) DEFAULT NULL, 
  `employeeAttributeType` varchar(45) DEFAULT NULL, 
  `employeeAttributeValue` varchar(45) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_administration_setting_leave_type_1_idx` (`administrationSettingsId`), 
  KEY `fk_hr_administration_setting_leave_type_2_idx` (`leaveTypeId`), 
  KEY `fk_hr_administration_setting_leave_type_3_idx` (`lastUpdatedBy`), 
  KEY `fk_hr_administration_leave_type_1_idx` (`employeeAttributeMasterId`), 
  CONSTRAINT `fk_hr_administration_leave_type_1` FOREIGN KEY (`employeeAttributeMasterId`) REFERENCES `hr_employee_attribute_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_administration_setting_leave_type_1` FOREIGN KEY (`administrationSettingsId`) REFERENCES `hr_administration_setting` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_administration_setting_leave_type_2` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_administration_setting_leave_type_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 


CREATE TABLE `hr_administration_leave_type_al` ( 
  `id` bigint(20) NOT NULL AUTO_INCREMENT, 
  `administrationLeaveTypeId` bigint(20) DEFAULT NULL, 
  `academyLocationId` bigint(20) DEFAULT NULL, 
  `lastUpdatedBy` bigint(20) NOT NULL, 
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, 
  PRIMARY KEY (`id`), 
  KEY `fk_hr_administration_setting_leave_type_al_1_idx` (`administrationLeaveTypeId`), 
  KEY `fk_hr_administration_setting_leave_type_al_2_idx` (`academyLocationId`), 
  KEY `fk_hr_administration_setting_leave_type_al_3_idx` (`lastUpdatedBy`), 
  CONSTRAINT `fk_hr_administration_setting_leave_type_al_1` FOREIGN KEY (`administrationLeaveTypeId`) REFERENCES `hr_administration_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_administration_setting_leave_type_al_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION, 
  CONSTRAINT `fk_hr_administration_setting_leave_type_al_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION 
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 
