-- Applicant Other Information
CREATE TABLE `applicant_other_information` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `applicantPersonId_UNIQUE_key` (`applicantPersonId` ASC),
  KEY `fk_applicant_other_information_applicantPersonId` (`applicantPersonId`),
  KEY `fk_applicant_other_information_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_applicant_other_information_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `fk_applicant_other_information_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Applicant Other Information Custom Data
CREATE TABLE `applicant_other_information_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantOtherInfoId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `fk_applicant_other_information_cd_id` (`applicantOtherInfoId`),
  KEY `fk_applicant_other_information_cd_users` (`lastUpdatedBy`),
  CONSTRAINT `fk_applicant_other_information_cd_id` FOREIGN KEY (`applicantOtherInfoId`) REFERENCES `applicant_other_information` (`id`),
  CONSTRAINT `fk_applicant_other_information_cd_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
