CREATE TABLE `question_paper_bank_assignment` (
  `id` BIGINT(20) NOT NULL,
  `questionPaperBankId` BIGINT(20) NOT NULL,
  `assignedUserId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `question_paper_bank_assignment_questionPaperBankId_idx` (`questionPaperBankId` ASC),
  INDEX `question_paper_bank_assignment_assignedUserId_idx` (`assignedUserId` ASC),
  INDEX `question_paper_bank_assignment_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `question_paper_bank_assignment_questionPaperBankId`
    FOREIGN KEY (`questionPaperBankId`)
    REFERENCES `question_paper_bank` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_assignment_assignedUserId`
    FOREIGN KEY (`assignedUserId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_assignment_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);