set sql_safe_updates = 0;

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT applicationId AS application_id ,programId AS program_id ,academyLocationId AS academy_location_id,a.applicantPersonId as applicant_person_id , progBatchSeatConfigId as program_batch_seat_configid FROM application_program ap left join application a on ap.applicationId = a.id' WHERE `dataSourceCode`='OFFER_LETTER_ADDITIONAL_PARAM';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\n pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\n psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\n b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\n ay.yearName AS academic_year\n FROM application_program aprgm\n LEFT JOIN programs p ON aprgm.programId = p.id\n LEFT JOIN prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id\n LEFT JOIN batches b   ON b.id = pbsc.programBatchId\n LEFT JOIN academy_year ay ON ay.id = b.academicYear\n LEFT JOIN department pd ON pd.id = p.programDepartmentId\n LEFT JOIN department psd ON psd.id = p.subDepartmentId' WHERE `dataSourceCode`='APPLICATION_INFO' and `executionOrder` = 2;

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, \n ap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,\n s.salutationName as applicant_salutation,ap.birthDate as birth_date\n FROM application a\n LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id\n LEFT JOIN salutations s ON ap.salutationId = s.id' WHERE `dataSourceCode`='APPLICATION_INFO' and executionOrder='3';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT \n al.academyId AS academy_id , al.locationId AS location_id , al.academyName AS academy_name , al.locationName AS location_name,\n c.countryName AS country_name , cr.countryRegionName AS region_name ,\n pr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\n ad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\n ad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\n ad.primaryeEmailId as primary_email_id, al.path as img_academy_location\n FROM academy_location al\n LEFT JOIN location_addresses la ON al.locationId = la.locationId\n LEFT JOIN address ad ON la.addressId = ad.id AND ad.addressTypeId = 3\n LEFT JOIN city ct ON ct.id =ad.cityId\n LEFT JOIN country c ON ad.countryId = c.id\n LEFT JOIN country_region cr ON ad.countryRegionId = cr.id\n LEFT JOIN country_region pr ON ad.parentRegionId = pr.id' WHERE `dataSourceCode`='ACADEMYLOCATION_ADDRESS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT \n al.academyName as academy_name,al.locationName as location_name,\n p.programCode as program_code ,p.programName as program_name,p.programNameToBePrint as program_print_name ,\n b.batchName as batch_name,b.startDate as batch_start_date,b.tillDate as batch_till_date,\n st.seatCode as seat_code,st.seatName as seat_name \n from application_program ap\n LEFT JOIN academy_location al ON ap.academyLocationId = al.id\n LEFT JOIN programs p ON p.id = ap.programId\n LEFT JOIN prog_batch_seat_config pbsc ON pbsc.id  = ap.progBatchSeatConfigId \n LEFT JOIN batches b ON b.id = pbsc.programBatchId \n LEFT JOIN seat_types st ON pbsc.seatTypeId=st.id' WHERE `dataSourceCode`='APPLICATION_PROGRAM_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT ap.firstName AS app_first_name,ap.middleName AS app_middle_name , ap.lastName AS app_last_name,\n        ap.mobileNumber AS app_mobile_number , ap.emailId AS app_email_id, ap.gender AS app_gender,\n        ap.birthDate AS app_birthdate, ap.bloodGroup AS app_bloodgroup, ap.photoURL AS img_app_photo_url,\n        ap.maritalStatus AS app_marital_status, ap.printName AS app_print_name,\n        ap.personalIncome AS app_personal_income, ap.occupation AS app_occupation,\n        ap.category AS app_category,a.code AS applctn_code,\n        cs.itemValue AS app_caste_category,rg.itemValue AS app_religion,nt.itemValue AS app_nationality,\n        cn.countryName AS app_country_name,sn.salutationName AS app_salutation\n FROM applicant_person ap \n LEFT JOIN application a ON a.applicantPersonId = ap.id\n LEFT JOIN caste_categories cs ON cs.id = ap.casteCategoryId\n LEFT JOIN religions rg ON rg.id = ap.religionId\n LEFT JOIN nationalities nt ON nt.id = ap.nationalityId\n LEFT JOIN country cn ON cn.id = ap.countryId        \n LEFT JOIN salutations sn ON sn.id = ap.salutationId' WHERE `dataSourceCode`='APPLICANT_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT o.orgName as organization_name,c.countryName AS country_name , cr.countryRegionName AS region_name ,\n pr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\n ad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\n ad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\n ad.primaryeEmailId AS primary_email_id\n FROM organizations o\n LEFT JOIN organization_addresses oa ON o.id = oa.organizationId\n LEFT JOIN address ad ON oa.addressId = ad.id AND ad.addressTypeId AND ad.addressTypeId=1\n LEFT JOIN city ct ON ct.id =ad.cityId\n LEFT JOIN country c ON ad.countryId = c.id\n LEFT JOIN country_region cr ON ad.countryRegionId = cr.id\n LEFT JOIN country_region pr ON ad.parentRegionId = pr.id' WHERE `dataSourceCode`='ORGANIZATION_ADDRESS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='\n SELECT    dt.itemCode AS document_code ,dt.itemValue AS document_name ,ard.status AS document_submission_status \n FROM application_program ap\n LEFT JOIN program_selection_process psp ON psp.programBatchSeatConfigId = ap.progBatchSeatConfigId\n LEFT JOIN application_required_documents ard ON psp.id = ard.programSelectionProcessId\n LEFT JOIN document_types dt ON ard.documentTypeId = dt.id' WHERE `dataSourceCode`='ADMISSION_PENDING_DOCUMENTS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT p.printName AS sales_head_printname,p.mobileNumber as sales_head_mobile\n FROM academy_location_purpose alp\n LEFT JOIN staffs s ON s.userId = alp.ownerId\n LEFT JOIN persons p ON p.id = s.personId' WHERE `dataSourceCode`='ACAD_LCTN_SALES_OWNER';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT b.bankCode AS bank_code,b.ifscCode AS ifsc_code,b.accountNo AS bank_account_no, b.bankName AS bank_name,' WHERE `dataSourceCode`='ACADEMY_LOCATION_BANKS';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='select apf.printName as father_name from applicant_person_relationships as apr\n LEFT join applicant_person as ap on apr.applicantPersonId = ap.id\n LEFT join applicant_person as apf on apr.relatedApplicantPersonId = apf.id' WHERE `dataSourceCode`='APPLICANT_FATHER_NAME';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='select round(datediff(b.tillDate,b.startDate) / 365) as batch_year, \n DATE_FORMAT(b.startDate ,\'%d-%m-%Y\') as batch_start_date,\n if(b.batchPartTime=1, \'Part Time\', \'Full Time\') as batch_study_mode \n from application_program as ap\n LEFT join prog_batch_seat_config as pbsc on ap.progBatchSeatConfigId = pbsc.id\n LEFT join batches as b on pbsc.programBatchId = b.id' WHERE `dataSourceCode`='BATCH_DETAILS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\n pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\n psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\n b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\n ay.yearName AS academic_year ,a.code AS admission_code ,a.studentId as student_id\n FROM admission a\n LEFT JOIN programs p ON a.programId = p.id\n LEFT JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id\n LEFT JOIN batches b   ON b.id = pbsc.programBatchId\n LEFT JOIN academy_year ay ON ay.id = b.academicYear\n LEFT JOIN department pd ON pd.id = p.programDepartmentId\n LEFT JOIN department psd ON psd.id = p.subDepartmentId' WHERE `dataSourceCode`='ADMISSION_INFO' and `publishAsParametersDef`='student_id=PRM_STUDENT_ID';
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName AS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,sln.salutationName AS applicant_salutation,p.birthDate AS birth_date,cc.itemCode as student_caste,r.itemCode as student_religion,cou.countryName as student_country FROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON p.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id LEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id' WHERE `dataSourceCode`='ADMISSION_INFO' and `publishAsParametersDef` is null;


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT academy.academyName AS academy_name,academy.academicTypeCode AS academic_type_code,academy.shortCode AS academy_short_code,location.locationName AS location_name,location.shortCode AS location_short_code \n FROM academy_location al\n LEFT JOIN academies academy ON academy.id=al.academyId\n LEFT JOIN locations location ON location.id=al.locationId' WHERE `dataSourceCode`='ACADEMY_LOCATION_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT T3.sponsorshipPercentage AS sponsorshipPercentage,T3.amountType AS amountType,T3.amount AS amount\n FROM sponsorship_awardees T1\n LEFT JOIN sponsorship_awarded_items T2 ON T2.sponsorshipAwardeeId=T1.id\n LEFT JOIN sponsorship_installments T3 ON T3.sponsorshipAwardedItemId=T2.id' WHERE `dataSourceCode`='SPONSORSHIP_INSTALLMENT_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT 	T2.itemCode AS documentCode,T2.itemValue AS documentName\n FROM `application_required_documents` T1\n LEFT JOIN document_types T2 ON T2.id = T1.documentTypeId' WHERE `dataSourceCode`='SELECTION_STAGE_PENDING_DOCUMENT_INFO';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' select per_father.firstName as father_first_name,per_father.lastName as father_last_name from students st\n LEFT JOIN persons per ON st.personId=per.id \n    LEFT JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'FATHER\'\n    LEFT JOIN persons per_father ON per_rel.relatedPersonId=per_father.id' WHERE `dataSourceCode`='Student Fathers Info';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='	select per_mother.firstName as mother_first_name,per_mother.lastName as mother_last_name from students st\n LEFT JOIN persons per ON st.personId=per.id \n    LEFT JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'MOTHER\'\n    LEFT JOIN persons per_mother ON per_rel.relatedPersonId=per_mother.id\n ' WHERE `dataSourceCode`='Student Mothers Info';

INSERT INTO `dydt_data_provider` (`providerName`, `priority`) VALUES ('STUDENT_ADDRESS_INFO', '1');
SET @maxId1=(SELECT MAX(dataProviderId) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@maxId1+1, 'STUDENT_ADDRESS_INFO', '1', '1', '1', 'select\n        addr.addressText\n    from\n        students s \n    left outer join\n        persons p \n            on s.personId=p.id \n    left outer join\n        person_addresses pa \n           on p.id=pa.personId  and pa.whetherPrimary=true\n	 left outer join\n        address addr \n            on pa.addressId=addr.id', 'PRM_STUDENT_ID', 'addressText', 'where   s.userId =PRM_STUDENT_ID\r  group by s.userId', '0');

INSERT INTO `dydt_data_provider` (`providerName`, `priority`) VALUES ('STUDENT_ACADEMIC_TENUER_INFO', '1');
SET @maxId2=(SELECT MAX(dataProviderId) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@maxId2+1, 'STUDENT_ACADEMIC_TENUER_INFO', '1', '1', '1', 'select\n        period.programPeriodName,\n		ay.yearName,\n		ayt.tenureName\n    from\n        program_batch_students pbs \n    left outer join\n        admission adm \n            on pbs.admissionId=adm.id \n    left outer join\n        students std \n           on adm.studentId=std.userId\n	 left outer join\n        prog_batch_period_config period \n            on period.id=progBatchPeriodConfigId\n	left outer join\n        academy_year ay \n	on ay.id=period.academicYear\n	left outer join\n        academy_year_tenure ayt \n	on ayt.id=period.academicYearTenureId', 'PRM_STUDENT_ID', 'programPeriodName,\nyearName,\ntenureName', 'where   std.userId =PRM_STUDENT_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and pbs.isPeriodCompleted = false and\r pbs.exitDate is null\r  group by std.userId', '0');

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName \nAS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,\nsln.salutationName AS applicant_salutation,p.birthDate AS birth_date,cc.itemCode as \nstudent_caste,r.itemCode as student_religion,cou.countryName as student_country  , user.code as student_code \nFROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON \np.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id \nLEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id\nLEFT JOIN users user ON s.userId=user.id', `resultColumnsDef`='student_firstname,student_lastname,student_middlename,student_gender,student_printname,applicant_salutation,birth_date,student_caste,student_religion,student_country, student_code' WHERE `id`='17' and`whetherPrimaryDataSource`='1';





set sql_safe_updates = 1;

