CREATE TABLE `finance_hold` (
  `id` bigint(20) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `cutoffDate` date NOT NULL,
  `createdBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `finance_hold_criteria` (
  `id` bigint(20) NOT NULL,
  `holdType` varchar(255) NOT NULL,
  `pendingFeePercent` varchar(255) NOT NULL,
  `lastUpdate` bigint(20) NOT NULL,
  `lastUpdatedBy` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `financeHoldId` bigint(20) NOT NULL,
  `createdBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_finance_hold_critieria_to_finance_hold_idx` (`financeHoldId`),
  KEY `fk_finance_hold_critieria_created_type_idx` (`createdBy`),
  CONSTRAINT `fk_finance_hold_critieria_created_type` FOREIGN KEY (`createdBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_finance_hold_critieria_to_finance_hold` FOREIGN KEY (`financeHoldId`) REFERENCES `finance_hold` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `finance_hold_prog_batch_seat_config` (
  `id` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `programBatchSeatConfigId` bigint(20) NOT NULL,
  `createdBy` bigint(20) NOT NULL,
  `lastUpdate` bigint(20) NOT NULL,
  `lastUpdatedBy` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_finance_hold_prog_batch_seat_config_idx` (`programBatchSeatConfigId`),
  KEY `fk_finance_hold_prog_batch_seat_config_acad_location_idx` (`academyLocationId`),
  KEY `fk_finance_hold_prog_batch_seat_config_users_idx` (`lastUpdate`),
  KEY `fk_finance_hold_prog_batch_seat_config_created_by_user_idx` (`createdBy`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config` FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_acad_location` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_created_by_user` FOREIGN KEY (`createdBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_users` FOREIGN KEY (`lastUpdate`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `student_finance_hold` (
  `id` bigint(20) NOT NULL,
  `studentId` bigint(20) NOT NULL,
  `programBatchSeatConfigId` bigint(20) NOT NULL,
  `financeHoldCriteriaId` bigint(20) NOT NULL,
  `status` varchar(255) NOT NULL,
  `unblockedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_student_finance_hold_student_idx` (`studentId`),
  KEY `fk_student_finance_hold_prog_batch_seat_config_idx` (`programBatchSeatConfigId`),
  KEY `fk_student_finance_hold_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_student_finance_hold_createdBy_idx` (`unblockedBy`),
  CONSTRAINT `fk_student_finance_hold_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_finance_hold_prog_batch_seat_config` FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`),
  CONSTRAINT `fk_student_finance_hold_student` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `fk_student_finance_hold_unblockedBy` FOREIGN KEY (`unblockedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
