DROP TABLE `finance_hold_prog_batch_seat_config`;
CREATE TABLE `finance_hold_prog_batch_seat_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `programBatchSeatConfigId` bigint(20) NOT NULL,
  `financeHoldId` bigint(20) NOT NULL,
  `createdBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `programBatchPeriodConfigId` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_finance_hold_prog_batch_seat_config_idx` (`programBatchSeatConfigId`),
  KEY `fk_finance_hold_prog_batch_seat_config_acad_location_idx` (`academyLocationId`),
  KEY `fk_finance_hold_prog_batch_seat_config_users_idx` (`lastUpdate`),
  KEY `fk_finance_hold_prog_batch_seat_config_created_by_user_idx` (`createdBy`),
  KEY `fk_finance_hold_prog_batch_seat_config_prog_batch_period_co_idx` (`programBatchPeriodConfigId`),
  KEY `fk_finance_hold_prog_batch_seat_config_finance_hold_idx` (`financeHoldId`),
  KEY `fk_finance_hold_prog_batch_seat_config_lastUpdated_by_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config` FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_acad_location` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_created_by_user` FOREIGN KEY (`createdBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_finance_hold` FOREIGN KEY (`financeHoldId`) REFERENCES `finance_hold` (`id`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_lastUpdated_by` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_finance_hold_prog_batch_seat_config_prog_batch_period_config` FOREIGN KEY (`programBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;