CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_delayed_course_cbs` AS
    (select 
        `ccp`.`academyLocationId` AS `academyLocationId`,
        `ccp`.`courseId` AS `courseId`,
        `ccp`.`sectionId` AS `sectionId`,
        concat(`al`.`academyName`,
                ' - ',
                `al`.`locationName`) AS `AcademyLocation`,
        `c`.`courseName` AS `CourseName`,
        `cv`.`courseVariantCode` AS `CourseVariantCode`,
        `u`.`id` AS `facultyId`,
        `u`.`printName` AS `facultyName`,
        count(0) AS `TotalSessions`,
        count((case
            when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
        end)) AS `SessionTillDate`,
        count((case
            when
                ((`ccp`.`sessionDate` <= sysdate())
                    and (`fpa`.`facultyId` is not null)
                    and (`fpa`.`attendanceStatus` = 'PRESENT'))
            then
                `fpa`.`facultyId`
        end)) AS `SesssionConductedTillDate`,
        (count((case
            when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
        end)) - count((case
            when
                ((`ccp`.`sessionDate` <= sysdate())
                    and (`fpa`.`facultyId` is not null)
                    and (`fpa`.`attendanceStatus` = 'PRESENT'))
            then
                `fpa`.`facultyId`
        end))) AS `DueTillDate`,
        round((((count((case
                    when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
                end)) - count((case
                    when
                        ((`ccp`.`sessionDate` <= sysdate())
                            and (`fpa`.`facultyId` is not null)
                            and (`fpa`.`attendanceStatus` = 'PRESENT'))
                    then
                        `fpa`.`facultyId`
                end))) / count(0)) * 100),
                2) AS `Deviation`
    from
        ((((((`course_coverage_plan` `ccp`
        left join `academy_location` `al` ON ((`ccp`.`academyLocationId` = `al`.`id`)))
        left join `courses` `c` ON ((`ccp`.`courseId` = `c`.`id`)))
        left join `course_variants` `cv` ON ((`ccp`.`courseVariantId` = `cv`.`id`)))
        left join `users` `u` ON ((`ccp`.`facultyId` = `u`.`id`)))
        left join `attendance_academylocationwise_setup` `setting` ON ((`ccp`.`academyLocationId` = `setting`.`academyLocationId`)))
        left join `faculty_program_attendance` `fpa` ON (((`ccp`.`facultyId` = `fpa`.`facultyId`)
            and (`ccp`.`sessionDate` = `fpa`.`dateOfAttendance`)
            and (`ccp`.`academyLocationId` = `fpa`.`academyLocationId`))))
    where
        (`c`.`assignSectionType` = 'CourseSection')
    group by `ccp`.`courseVariantId`) union (select 
        `ccp`.`academyLocationId` AS `academyLocationId`,
        `ccp`.`courseId` AS `courseId`,
        `ccp`.`sectionId` AS `sectionId`,
        concat(`al`.`academyName`,
                ' - ',
                `al`.`locationName`) AS `AcademyLocation`,
        `c`.`courseName` AS `CourseName`,
        `cv`.`courseVariantCode` AS `CourseVariantCode`,
        `u`.`id` AS `facultyId`,
        `u`.`printName` AS `facultyName`,
        count(0) AS `TotalSessions`,
        count((case
            when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
        end)) AS `SessionTillDate`,
        count((case
            when
                ((`ccp`.`sessionDate` <= sysdate())
                    and (`fcad`.`facultyId` is not null)
                    and (`fcad`.`attendanceStatus` = 'PRESENT'))
            then
                `fcad`.`facultyId`
        end)) AS `SesssionConductedTillDate`,
        (count((case
            when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
        end)) - count((case
            when
                ((`ccp`.`sessionDate` <= sysdate())
                    and (`fcad`.`facultyId` is not null)
                    and (`fcad`.`attendanceStatus` = 'PRESENT'))
            then
                `fcad`.`facultyId`
        end))) AS `DueTillDate`,
        round((((count((case
                    when (`ccp`.`sessionDate` <= sysdate()) then `ccp`.`id`
                end)) - count((case
                    when
                        ((`ccp`.`sessionDate` <= sysdate())
                            and (`fcad`.`facultyId` is not null)
                            and (`fcad`.`attendanceStatus` = 'PRESENT'))
                    then
                        `fcad`.`facultyId`
                end))) / count(0)) * 100),
                2) AS `Deviation`
    from
        (((((((`course_coverage_plan` `ccp`
        left join `academy_location` `al` ON ((`ccp`.`academyLocationId` = `al`.`id`)))
        left join `courses` `c` ON ((`ccp`.`courseId` = `c`.`id`)))
        left join `course_variants` `cv` ON ((`ccp`.`courseVariantId` = `cv`.`id`)))
        left join `users` `u` ON ((`ccp`.`facultyId` = `u`.`id`)))
        left join `attendance_academylocationwise_setup` `setting` ON ((`ccp`.`academyLocationId` = `setting`.`academyLocationId`)))
        left join `faculty_course_attendance` `fca` ON (((`ccp`.`academyLocationId` = `fca`.`academyLocationId`)
            and (`ccp`.`sessionDate` = `fca`.`dateOfAttendance`))))
        left join `faculty_course_attendance_details` `fcad` ON (((`fca`.`id` = `fcad`.`attendanceId`)
            and (`ccp`.`facultyId` = `fcad`.`facultyId`))))
    where
        (`c`.`assignSectionType` = 'CourseSection')
    group by `ccp`.`courseVariantId`);
