CREATE TABLE `school_leaving_request_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRequestId` bigint(20) NOT NULL,
  `programId` bigint(20) NOT NULL,
  `dateOfTransfer` date NOT NULL,
  `noticeTermId` bigint(20) DEFAULT NULL,
  `termEndDate` date DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sl_serviceRequestId_idx` (`serviceRequestId`),
  KEY `fk_sl_programId_idx` (`programId`),
  KEY `fk_sl_noticetermId_idx` (`noticeTermId`),
  KEY `fk_sl_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_sl_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_sl_noticetermId` FOREIGN KEY (`noticeTermId`) REFERENCES `period_term_definition` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_sl_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_sl_serviceRequestId` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;