CREATE TABLE `service_request_program_group_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programGroupDetailsId` bigint(20) NOT NULL,
  `defaultAssigneeUserId` bigint(20) DEFAULT NULL,
  `defaultApproverUserId` bigint(20) DEFAULT NULL,
  `serviceRequestSettingId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_srpgc_pgdId_idx` (`programGroupDetailsId`),
  KEY `fk_srpgc_assigneeId_idx` (`defaultAssigneeUserId`),
  KEY `fk_srpgc_appoverId_idx` (`defaultApproverUserId`),
  KEY `fk_srpgc_last_updatedby_idx` (`lastUpdatedBy`),
  KEY `fk_srpgc_srsId_idx` (`serviceRequestSettingId`),
  CONSTRAINT `fk_srpgc_appoverId` FOREIGN KEY (`defaultApproverUserId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_srpgc_assigneeId` FOREIGN KEY (`defaultAssigneeUserId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_srpgc_last_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_srpgc_pgdId` FOREIGN KEY (`programGroupDetailsId`) REFERENCES `program_group_details` (`id`),
  CONSTRAINT `fk_srpgc_srsId` FOREIGN KEY (`serviceRequestSettingId`) REFERENCES `service_request_settings` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
