CREATE TABLE `delete_student` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `studentCode` VARCHAR(255) NOT NULL,
  `studentName` VARCHAR(255) NOT NULL,
  `emailId` VARCHAR(255) NOT NULL,
  `intakeYearId` BIGINT(20) NOT NULL,
  `academicTermId` BIGINT(20) NULL,
  `programGroupId` BIGINT(20) NOT NULL,
  `programId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `periodId` BIGINT(20) NULL,
  `progBatchSeatConfigId` BIGINT(20) NOT NULL,
  `status` BIT(1) NOT NULL,
  `whetherProcessed` BIT(1) NOT NULL DEFAULT b'1',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_delete_student_intakeYear_idx` (`intakeYearId` ASC),
  INDEX `fk_delete_student_academicTerm_idx` (`academicTermId` ASC),
  INDEX `fk_delete_student_programGroup_idx` (`programGroupId` ASC),
  INDEX `fk_delete_student_program_idx` (`programId` ASC),
  INDEX `fk_delete_student_batch_idx` (`batchId` ASC),
  INDEX `fk_delete_student_ProgramBatchPeriod_idx` (`periodId` ASC),
  INDEX `fk_delete_student_ProgramBatchSeatConfig_idx` (`progBatchSeatConfigId` ASC),
  INDEX `fk_student_deleted_BY_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_delete_student_intakeYear`
    FOREIGN KEY (`intakeYearId`)
    REFERENCES `intake_year` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_academicTerm`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_programGroup`
    FOREIGN KEY (`programGroupId`)
    REFERENCES `program_group` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_program`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_batch`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_ProgramBatchPeriod`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_delete_student_ProgramBatchSeatConfig`
    FOREIGN KEY (`progBatchSeatConfigId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_deleted_by`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
