CREATE TABLE `offline_payment_header` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `receiptFor` BIGINT(20) NULL DEFAULT 1,
  `voucherMode` VARCHAR(10) NOT NULL DEFAULT 'BANK',
  `receiptNo` VARCHAR(45),
  `currencyId` BIGINT(20) NULL DEFAULT 1,
  `createdOn` DATE NOT NULL,
  `amount` DOUBLE(20,2) NOT NULL,
  `status` VARCHAR(50) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  `studentId` BIGINT(20) NULL,
  `proofno` VARCHAR(45) NOT NULL,
  `noOfDocuments` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `Refusers1389_idx` (`lastUpdatedBy` ASC),
  INDEX `Refstudent43543_idx` (`studentId` ASC),
  INDEX `Refcurrency34_idx` (`currencyId` ASC),
  INDEX `RefStatus3412_idx` (`status` ASC),
  INDEX `proofNo345_idx` (`proofno` ASC),
  INDEX `createdOn5_idx` (`createdOn` ASC),
  INDEX `Refbilledusertype3654_idx` (`receiptFor` ASC),
  CONSTRAINT `RefacademyLoaction2019`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Refbilledusertype2019`
    FOREIGN KEY (`receiptFor`)
    REFERENCES `billed_user_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Refcurrency2019`
    FOREIGN KEY (`currencyId`)
    REFERENCES `currency` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Refstudent2019`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Refusers2019`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
