
SET SQL_SAFE_UPDATES = 0;

INSERT INTO `ui_translation` 
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PROGRAMANDCOURSE','Import_ASC_Timetable','Import ASC Timetable','Import ASC Timetable',now(),1);

INSERT INTO `ui_translation` 
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PROGRAMANDCOURSE','IMPORT_TIME_TABLE_XML_FILE','Please upload xml file only','Please upload xml file only' ,now(),1);

INSERT INTO `ui_translation` 
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PROGRAMANDCOURSE','UPLOAD_XML_DATA','Upload XML File' ,'Upload XML File' ,now(),1);

INSERT INTO `ui_translation` 
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PROGRAMANDCOURSE','XML_IMPORT_TIME_TABLE' ,'XML Import Time Table', 'XML Import Time Table' ,now(),1);

SET SQL_SAFE_UPDATES = 1;

CREATE TABLE `xml_timetable` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `calendarId` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `displayName` varchar(255) DEFAULT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `importDate` timestamp NULL DEFAULT NULL,
  `exexutionDate` timestamp NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `importStatus` varchar(255) NOT NULL,
  `whetherRecordFail` bit(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Idx_xml_timetable_LastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_xml_timetable_calendarId_idx` (`calendarId`),
  KEY `fk_xml_timetable_academyLocationId_idx` (`academyLocationId`),
  CONSTRAINT `fk_xml_timetable_calendarId` FOREIGN KEY (`calendarId`) REFERENCES `calendars` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_xml_timetable_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_xml_timetable_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)ON DELETE RESTRICT ON UPDATE RESTRICT);