set sql_safe_updates=0;

SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
	p.emailId AS EMAIL_ID,
    oldp.alternateEmailId AS ALTERNATE_EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
	sal.salutationName AS SALUTATION_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
        LEFT JOIN
    staffs s ON s.userId = T1.facultyId
        LEFT JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
        LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
        LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
WHERE
    T1.id IN (namedParams)
GROUP BY T1.courseCoveragePlanId" WHERE `dataProviderId`=@ttfDtProviderId;

set sql_safe_updates=1;

