DELIMITER $$

DROP PROCEDURE IF EXISTS V202001061559__Insert_NationalityWiseReportTranslations $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001061559__Insert_NationalityWiseReportTranslations()

BEGIN

	set @reportTempId1 = (select max(id) from report_template where templateCode='STUDENT_NATIONALITY_WISE_REPORT');
  
  -- Insert new record in report_template_translations table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId1 AND 
  keyValue='TRANS_PROGRAM')) THEN
    	
	INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId1, 'TRANS_PROGRAM', 'Program', '1');
	
  END IF;
  
   -- Insert new record in report_template_translations table, if it doesn't already exist
   IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId1 AND 
  keyValue='TRANS_SECTION')) THEN
    
	-- Insert Query 
	INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId1, 'TRANS_SECTION', 'Section', '1');
	
  END IF;
  
   -- Insert new record in report_template_translations table, if it doesn't already exist
   IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId1 AND 
  keyValue='TRANS_REPORT_TITLE')) THEN

	INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId1, 'TRANS_REPORT_TITLE', 'Student Nationality Report', '1');
	
  END IF;
  
END $$

-- Execute the stored procedure
CALL V202001061559__Insert_NationalityWiseReportTranslations() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001061559__Insert_NationalityWiseReportTranslations $$
 
DELIMITER ;

