DELIMITER $$

DROP PROCEDURE IF EXISTS add_column_to_course_coverage_plan_msg_table $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_column_to_course_coverage_plan_msg_table()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='course_coverage_plan_msg' 
  AND COLUMN_NAME='reasonForSubstituteSession')) THEN

    ALTER TABLE `course_coverage_plan_msg` 
ADD COLUMN `reasonForSubstituteSession` VARCHAR(500) NULL DEFAULT NULL;

  END IF;

END $$

-- Execute the stored procedure
CALL add_column_to_course_coverage_plan_msg_table() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_column_to_course_coverage_plan_msg_table $$
 
DELIMITER ;
