DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071814__InsertDFRFollowUpDetails $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071814__InsertDFRFollowUpDetails()

BEGIN
  
  -- Insert new record in form_field_info table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='actualApplicantFollowUpDate')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','actualApplicantFollowUpDate','actualApplicantFollowUpDate','datefield',1,1,NULL,1,now(),'Follow-up Date','1','Applicant Follow-up Details',' View','Follow-up Date',0);
  

  END IF;
  
IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantFollowupTime')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantFollowupTime','applicantFollowupTime','timefield',0,0,NULL,1,now(),'Follow-up Time','1','Applicant Follow-up Details',' View','Follow-up Time',0);
  

  END IF;  
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantFollowupuser')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantFollowupuser','applicantFollowUpUser','textfield',0,0,NULL,1,now(),'Follow-up User','1','Applicant Follow-up Details',' View','Follow-up User',0);
  

  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantFollowupActivityTo')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantFollowupActivityTo','applicantFollowupactivityto','textfield',0,0,NULL,1,now(),'Follow-up Activity To','1','Applicant Follow-up Details',' View','Follow-up Activity To',0);
  

  END IF; 
  
    IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantEmailAdress')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantEmailAdress','applicantEmailAdress','textfield',0,0,NULL,1,now(),'Email ID','1','Applicant Follow-up Details',' View','Email ID',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantDetail_cellNumber')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantDetail_cellNumber','applicantDetail_cellNumber','fieldcontainer',0,0,NULL,1,now(),'Mobile No.','1','Applicant Follow-up Details',' View','Mobile No.',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantFollowUpActivityType')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantFollowUpActivityType','applicantFollowupactivitytypeId','customcombobox',1,1,NULL,1,now(),'Follow-up Activity Type','1','Applicant Follow-up Details',' View','Follow-up Activity Type',0);
  

  END IF; 
  
    IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantReasonForFollowUp')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantReasonForFollowUp','applicantReasonforfollowup','customcombobox',1,1,NULL,1,now(),'Reason for Follow-up','1','Applicant Follow-up Details',' View','Reason for Follow-up',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantFollowUpActivityStatus')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantFollowUpActivityStatus','applicantFollowupactivitystatusId','customcombobox',1,1,NULL,1,now(),'Follow-up Activity Status','1','Applicant Follow-up Details',' View','Follow-up Activity Status',0);
  

  END IF; 
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantPriority')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantPriority','applicantPriority','customcombobox',1,1,NULL,1,now(),'Priority','1','Applicant Follow-up Details',' View','Priority',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='remark')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','remark','remarkItemId','textarea',0,0,NULL,1,now(),'Follow-up Remarks','1','Applicant Follow-up Details',' View','Follow-up Remarks',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantWhetherNextFollowUp')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantWhetherNextFollowUp','applicantWhetherNextFollowUpId','checkboxfield',0,0,NULL,1,now(),'Schedule Next Follow-up','1','Applicant Follow-up Details',' View','Schedule Next Follow-up',0);
  

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantNextFollowUpDate')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantNextFollowUpDate','applicantNextFollowUpDateId','datefield',1,1,NULL,1,now(),'Next Follow-up Date','1','Applicant Follow-up Details',' View','Next Follow-up Date',0);
  

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationfollowupdetailform' and  formFieldName ='applicantUserByAssignTo')) THEN
    
	-- Insert Query 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('applicationfollowupdetailform','applicantUserByAssignTo','applicantUserByAssignToId','customcombobox',1,1,NULL,1,now(),'Assigned To','1','Applicant Follow-up Details',' View','Assigned To',0);
  

  END IF;

END $$

-- Execute the stored procedure
CALL V202001071814__InsertDFRFollowUpDetails() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071814__InsertDFRFollowUpDetails $$
 
DELIMITER ;