DELIMITER $$

DROP PROCEDURE IF EXISTS Insert_UITranslation_Offer_Letter_Issued $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE Insert_UITranslation_Offer_Letter_Issued()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="OFFER_LETTER_ISSUED" )) THEN
    
    -- Insert Query 
    INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('TRANSLATIONS','OFFER_LETTER_ISSUED','Offer Letter Issued','Offer Letter Issued',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL Insert_UITranslation_Offer_Letter_Issued() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS Insert_UITranslation_Offer_Letter_Issued $$
 
DELIMITER ;