DELIMITER $$

DROP PROCEDURE IF EXISTS add_report_template $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_report_template()

BEGIN
  
	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'AIT_STUDENT_ID_CARD' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'AIT_STUDENT_ID_CARD', 'AIT Student ID Card', 'AIT_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical_ATMCardSize.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'AIT_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');

  END IF;

	-- Insert new record in report_template_translations table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='AIT_STUDENT_ID_CARD'))) THEN
    
	set @studentIDCard = (select id from report_template where templateCode ='AIT_STUDENT_ID_CARD');
	-- Insert Query 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_NAME', 'Name', '1', NOW()),
	(@studentIDCard, 'TRANS_STUDENT_CODE', 'USN', '1', NOW()),
	(@studentIDCard, 'TRANS_PROGRAM', 'Course', '1', NOW()),
	(@studentIDCard, 'TRANS_VALIDITY', 'Validity', '1', NOW()),
    (@studentIDCard, 'TRANS_EMERGENCY', 'Emergency', '1', NOW()),
    (@studentIDCard, 'TRANS_CONTACT', 'Contact', '1', NOW()),
    (@studentIDCard, 'TRANS_DOB', 'DOB', '1', NOW()),
    (@studentIDCard, 'TRANS_BLOOD', 'Blood Type', '1', NOW()),
    (@studentIDCard, 'TRANS_RESIDENTIAL', 'Residential', '1', NOW()),
    (@studentIDCard, 'TRANS_ADDRESS', 'Address', '1', NOW()),
    (@studentIDCard, 'TRANS_TEXT_AREA', 'This card is the property of the college and is non transferable. Misuse of this card is an offence. If found please returned to:', '1', NOW()),
    (@studentIDCard, 'TRANS_PRINCIPAL', 'The Principal', '1', NOW()),
    (@studentIDCard, 'TRANS_PHONE', 'Phone:', '1', NOW()),
    (@studentIDCard, 'TRANS_CHAR', 'R', '1', NOW());

  END IF;

END $$

-- Execute the stored procedure
CALL add_report_template() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_report_template $$
 
DELIMITER ;