DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224203340__Alter_UPDATE_DEPENDENT_FEE_HEAD $$
CREATE PROCEDURE V20200224203340__Alter_UPDATE_DEPENDENT_FEE_HEAD()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='bill_dependant_details' AND column_name='acadLocCurrencyConversionId' AND column_name='orgCurrencyConversionId' AND column_name='acadLocCurrConvertedFeeAmount' AND column_name = 'orgCurrConvertedFeeAmount')) THEN 
ALTER TABLE `bill_dependant_details` 
ADD COLUMN `acadLocCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `lastUpdate`,
ADD COLUMN `orgCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConversionId`,
ADD COLUMN `acadLocCurrConvertedFeeAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrencyConversionId`,
ADD COLUMN `orgCurrConvertedFeeAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedFeeAmount`,
ADD INDEX `fk_bill_dependent_detail_AcademyLocationCurrency_idx` (`acadLocCurrencyConversionId` ASC),
ADD INDEX `fk_bill_dependent_detail_OrganizationCurrency_idx` (`orgCurrencyConversionId` ASC);

ALTER TABLE `bill_dependant_details` 
ADD CONSTRAINT `fk_bill_dependent_detail_AcademyLocationCurrency`
  FOREIGN KEY (`acadLocCurrencyConversionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_bill_dependent_detail_OrganizationCurrency`
  FOREIGN KEY (`orgCurrencyConversionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

END IF; 

END $$
CALL V20200224203340__Alter_UPDATE_DEPENDENT_FEE_HEAD() $$
DROP PROCEDURE IF EXISTS V20200224203340__Alter_UPDATE_DEPENDENT_FEE_HEAD $$
DELIMITER ;