DELIMITER $$
DROP PROCEDURE IF EXISTS V20200225161734__Create_HWAssignmentSeqDetail $$
CREATE PROCEDURE V20200225161734__Create_HWAssignmentSeqDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='homework_assignment_sequential_detail')) THEN 
CREATE TABLE `homework_assignment_sequential_detail` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `evaluationSequenceDetailId` BIGINT(20) NOT NULL,
  `hwAssignmentId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_homework_assignment_sequential_detail_1_idx` (`evaluationSequenceDetailId` ASC),
  INDEX `fk_homework_assignment_Id_idx` (`hwAssignmentId` ASC),
  CONSTRAINT `fk_homework_assignment_sequential_detail`
    FOREIGN KEY (`evaluationSequenceDetailId`)
    REFERENCES `eval_seq_detail` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_homework_assignment_Id`
    FOREIGN KEY (`hwAssignmentId`)
    REFERENCES `course_hw_asignment` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200225161734__Create_HWAssignmentSeqDetail () $$ 
DROP PROCEDURE IF EXISTS V20200225161734__Create_HWAssignmentSeqDetail $$ 
DELIMITER ;