DELIMITER $$
DROP PROCEDURE IF EXISTS V20200309155710__Insert_RGI_REPORT $$
CREATE PROCEDURE V20200309155710__Insert_RGI_REPORT()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RGI_HALL_TICKET')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('8', 'RGI_HALL_TICKET', 'RGI Hall Ticket', 'RGI_HALL_TICKET.png', 'CommonReport_RGI.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RGI_HALL_TICKET.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RGI_HALL_TICKET')) THEN 
set @RgiHallTicket = (select id from report_template where templateCode ='RGI_HALL_TICKET');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@RgiHallTicket, 'TRANS_SESSION', 'Session', '1', NOW()),
(@RgiHallTicket, 'TRANS_DELIMITER', ':', '1', NOW()),
(@RgiHallTicket, 'TRANS_SCHOOL', 'Name of the School', '1', NOW()),
(@RgiHallTicket, 'TRANS_EXAMINATION', 'Name of the Examination', '1', NOW()),
(@RgiHallTicket, 'TRANS_STUDENT', 'Name of the Student', '1', NOW()),
(@RgiHallTicket, 'TRANS_MOTHERS_NAME', 'Mother’s Name', '1', NOW()),
(@RgiHallTicket, 'TRANS_GENDER', 'Gender', '1', NOW()),
(@RgiHallTicket, 'TRANS_EXAMINEE_CATEGORY', 'Examinee Category', '1', NOW()),	
(@RgiHallTicket, 'TRANS_ROLL_NO', 'Roll No.', '1', NOW()),
(@RgiHallTicket, 'TRANS_REGISTRATION', 'Registration No.', '1', NOW()),
(@RgiHallTicket, 'TRANS_MEDIUM', 'Medium', '1', NOW()),
(@RgiHallTicket, 'TRANS_MEDIUM_VALUE', 'ENGLISH', '1', NOW()),
(@RgiHallTicket, 'TRANS_SRNO', 'Sr. No.', '1', NOW()),
(@RgiHallTicket, 'TRANS_COURSE_NAME', 'Course Name', '1', NOW()),
(@RgiHallTicket, 'TRANS_COURSE_CODE', 'Course Code', '1', NOW()),
(@RgiHallTicket, 'TRANS_EXAMINATION_DATES', 'Date of Examination', '1', NOW()),
(@RgiHallTicket, 'TRANS_EXAMINATION_TIME', 'Timings of Examinations', '1', NOW()),
(@RgiHallTicket, 'TRANS_INVIGILATOR', 'Signature of Invigilator', '1', NOW()),
(@RgiHallTicket, 'TRANS_CENTER', 'Centre Name:', '1', NOW()),
(@RgiHallTicket, 'TRANS_TEXT', 'ADMIT CARD FOR THE EXAMINATIONS/RE-EXAMINATIONS', '1', NOW()),
(@RgiHallTicket, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', NOW()),
(@RgiHallTicket, 'TRANS_COURSES_OFFERED', 'Courses Offered/ Schedule:', '1', NOW()),
(@RgiHallTicket, 'TRANS_SRNO', 'Sr. No.', '1', NOW()),
(@RgiHallTicket, 'TRANS_SEAL', 'Seal', '1', NOW()),
(@RgiHallTicket, 'TRANS_EXAMINATION_CONTROLLER', 'Controller of Examinations', '1', NOW());
END IF; 

END $$
CALL V20200309155710__Insert_RGI_REPORT() $$
DROP PROCEDURE IF EXISTS V20200309155710__Insert_RGI_REPORT $$
DELIMITER ;