DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402133831__Create_application_list_view $$
CREATE PROCEDURE V20200402133831__Create_application_list_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'Application_List_View')) THEN 
DROP view `Application_List_View`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_list_view')) THEN 
CREATE OR REPLACE VIEW `application_list_view` AS
select 
        `t3`.`code` AS `APPLICATION_ID`,
        `t2`.`printName` AS `FULL_NAME`,
        `t2`.`firstName` AS `FIRST_NAME`,
        `t2`.`middleName` AS `MIDDLE_NAME`,
        `t2`.`lastName` AS `LAST_NAME`,
        `t20`.`academyName` AS `ACADEMY`,
		`t4`.`displayName` AS `ACADEMY_DISPLAY_NAME`,
		`t4`.`academyCode` AS `ACADEMY_CODE`,
        `t19`.`locationName` AS `LOCATION`,
        `t5`.`programName` AS `PROGRAM_NAME`,
		`t5`.`programNameToBePrint` AS `PROGRAM_NAME_PRINTED`,
		`t5`.`programShortName` AS `PROGRAM_SHORT_NAME`,
        `pg`.`groupName` AS `PROGRAM_GROUP_NAME`,
        `t15`.`batchName` AS `BATCH`,
        `t8`.`seatName` AS `SEAT_TYPE`,
        `t52`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `t3`.`currentStatus` AS `APPLICATION_VIEW_STATUS`,
        `t51`.`value` AS `PROGRAM_WITHDRAWN_REASON`,
        `t1`.`currentStatus` AS `PROGRAM_VIEW_STATUS`,
        `t12`.`stageName` AS `CURRENT_STAGE`,
        `t1`.`offerLetterAcceptanceDate` AS `OFFER_LETTER_ACCEPTANCE_DATE`,
        `t9`.`currentStatus` AS `STAGE_VIEW_STATUS`,
        `t18`.`status` AS `ADMISSION_VIEW_STATUS`,
        `t3`.`applicationCreationSource` AS `APPLICATION_CREATION_SOURCE`,
        `t50`.`printName` AS `APPROVED_PERSON`,
        `t3`.`applicationApprovedOn` AS `APPLICATION_APPROVED_DATE`,
        `t3`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `t43`.`firstName` AS `FATHERS_FULL_NAME`,
        `t43`.`firstName` AS `FATHERS_FIRST_NAME`,
        `t43`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `t43`.`lastName` AS `FATHERS_LAST_NAME`,
        `t48`.`firstName` AS `MOTHERS_FULL_NAME`,
        `t48`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `t48`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `t48`.`lastName` AS `MOTHERS_LAST_NAME`,
        `t27`.`beneficiaryName` AS `BENEFICIARY_NAME`,
        `t27`.`accountNumber` AS `ACCOUNT_NUMBER`,
        `t27`.`accountType` AS `ACCOUNT_TYPE`,
        `t27`.`bankName` AS `BANK_NAME`,
        `t27`.`branchName` AS `BRANCH_NAME`,
        `t27`.`IFSCode` AS `IFSCODE`,
        `t2`.`birthDate` AS `DATE_OF_BIRTH`,
        `t2`.`gender` AS `GENDER`,
        `t2`.`category` AS `CATEGORY`,
        `t2`.`emailId` AS `EMAIL`,
        `t2`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `t2`.`mobileNumber` AS `MOBILE_NUMBER`,
        `t2`.`phoneCountryCode` AS `PHONE_COUNTRY_CODE`,
        `t2`.`phoneAreaCode` AS `PHONE_AREA_CODE`,
        `t2`.`phoneNo` AS `PHONE_NO`,
        `t2`.`bloodGroup` AS `BLOOD_GROUP`,
        `t45`.`itemValue` AS `RELIGION`,
        `t46`.`itemValue` AS `CASTE_CATEGORY`,
        `t2`.`comments` AS `APPLICATION_GRID_COMMENTS`,
        `t10`.`whetherFeePlanApplicable` AS `WHETHER_FEE_PLAN_APPLICABLE`,
        `t44`.`billStatus` AS `BILL_STATUS`,
        `t3`.`currentStatus` AS `APPLICATION_STATUS`,
        `t1`.`currentStatus` AS `PROGRAM_STATUS`,
        `t9`.`currentStatus` AS `STAGE_STATUS`,
        `t14`.`status` AS `ADMISSION_STATUS`,
        `t49`.`itemValue` AS `NATIONALITY`,
        `t2`.`nationalID` AS `NATIONAL_ID`,
        `t2`.`printName` AS `APPLICATION_PERSON_PRINTNAME`,
        `t2`.`id` AS `APPLICATION_PERSON_ID`,
        `t14`.`id` AS `ADMISSION_PRIMERY_ID`,
        `t3`.`id` AS `APPLICATION_PRIMERY_ID`,
        `t1`.`id` AS `APPLICATION_PROGRAM_ID`,
        `t7`.`id` AS `PROG_BATCH_SEAT_CONFIG_ID`,
        `t1`.`academyLocationId` AS `ACADEMY_LOCATION_ID`,
        `t3`.`id` AS `ID`,
        `t26`.`externalUserId` AS `EXTERNAL_USER_ID`,
        `t7`.`id` AS `IS_OFFER_LETTER_APPLICABLE`,
        `country`.`countryName` AS `COUNTRY_NAME`,
        `cr`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `city`.`cityName` AS `CITY_NAME`,
        `t89`.`itemCode` AS `intake_year`,
        `t89`.`id` AS `intakeYearId`,
        `address`.`id` AS `address_id`
    from
        ((((((((((((((((((((((((((((((((((`application` `t3`
        left join `external_user_association` `t26` ON (((`t3`.`id` = `t26`.`applicationId`)
            and (`t26`.`referencyEntityType` = 'APPLICATION'))))
        join `applicant_person` `t2` ON ((`t2`.`id` = `t3`.`applicantPersonId`)))
        left join `applicant_address` `address` ON (((`address`.`applicantPersonId` = `t2`.`id`)
            and (`address`.`whetherPrimary` = 1))))
        left join `country` ON ((`country`.`id` = `address`.`countryId`)))
        left join `country_region` `cr` ON ((`cr`.`id` = `address`.`parentRegionId`)))
        left join `city` ON ((`city`.`id` = `address`.`cityId`)))
        left join `application_program` `t1` ON ((`t3`.`id` = `t1`.`applicationId`)))
        left join `users` `t50` ON ((`t50`.`id` = `t3`.`applicationApprovedBy`)))
        left join `applicant_bank_details` `t27` ON ((`t2`.`bankDetailId` = `t27`.`id`)))
        left join `applicant_hostel_requirement` `t52` ON (((`t52`.`applicantPersonId` = `t2`.`id`)
            and (`t52`.`whetherDeleted` = 0))))
        left join `nationalities` `t49` ON ((`t2`.`nationalityId` = `t49`.`id`)))
        left join `caste_categories` `t46` ON ((`t2`.`casteCategoryId` = `t46`.`id`)))
        left join `applicant_person_relationships` `t42` ON (((`t42`.`applicantPersonId` = `t2`.`id`)
            and (`t42`.`relationship` = 'FATHER')
            and (`t42`.`whetherDeleted` = 0))))
        left join `religions` `t45` ON ((`t2`.`religionId` = `t45`.`id`)))
        left join `applicant_person_relationships` `t47` ON (((`t47`.`applicantPersonId` = `t2`.`id`)
            and (`t47`.`relationship` = 'MOTHER')
            and (`t47`.`whetherDeleted` = 0))))
        left join `application_admission_detail` `t18` ON ((`t18`.`applicationProgramId` = `t1`.`id`)))
        left join `programs` `t5` ON ((`t5`.`id` = `t1`.`programId`)))
        left join `program_group` `pg` ON ((`t5`.`programGroupId` = `pg`.`id`)))
        left join `academy_location` `t4` ON ((`t4`.`id` = `t1`.`academyLocationId`)))
        left join `prog_batch_seat_config` `t7` ON ((`t7`.`id` = `t1`.`progBatchSeatConfigId`)))
        left join `program_slctn_process_stages` `t10` ON ((`t10`.`id` = `t1`.`currentStageId`)))
        left join `application_prog_withdraw_reasons` `t51` ON ((`t51`.`id` = `t1`.`withdrawl_reason_id`)))
        left join `applicant_person` `t43` ON (((`t43`.`id` = `t42`.`relatedApplicantPersonId`)
            and (`t42`.`relationship` = 'FATHER')
            and (`t42`.`whetherDeleted` = 0))))
        left join `applicant_person` `t48` ON (((`t48`.`id` = `t47`.`relatedApplicantPersonId`)
            and (`t47`.`relationship` = 'MOTHER')
            and (`t47`.`whetherDeleted` = 0))))
        left join `admission` `t14` ON ((`t14`.`applicationAdmissionId` = `t18`.`id`)))
        left join `locations` `t19` ON ((`t19`.`id` = `t4`.`locationId`)))
        left join `academies` `t20` ON ((`t20`.`id` = `t4`.`academyId`)))
        left join `seat_types` `t8` ON ((`t8`.`id` = `t7`.`seatTypeId`)))
        left join `batches` `t15` ON ((`t15`.`id` = `t7`.`programBatchId`)))
        left join `intake_year` `t89` ON ((`t89`.`id` = `t15`.`intakeYearId`)))
        left join `application_prog_stage` `t9` ON (((`t9`.`applicationProgramId` = `t1`.`id`)
            and (`t9`.`programSelectionProcessStageId` = `t10`.`id`))))
        left join `slctn_process_stage` `t11` ON ((`t11`.`id` = `t10`.`selectionProcessStageId`)))
        left join `bill_header` `t44` ON ((`t44`.`applicationProgramStageId` = `t9`.`id`)))
        left join `selection_stage` `t12` ON ((`t12`.`id` = `t11`.`stageId`)))
    where
        ((`t3`.`applicationCreationSource` is not null)
            and (`t3`.`currentStatus` <> 'SOLD')
            and (`t3`.`currentStatus` not in ('DIRECT_SUBMISSION_TOKEN_GENERATED' , 'FORM_SALE_TOKEN_GENERATED'))
            and (`t3`.`code` is not null))
    order by `t3`.`applicationCreatedOn` desc;
END IF; 

END $$
CALL V20200402133831__Create_application_list_view () $$ 
DROP PROCEDURE IF EXISTS V20200402133831__Create_application_list_view $$ 
DELIMITER ;