DELIMITER $$

DROP PROCEDURE IF EXISTS V20200406125251__AlterPortalModules $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200406125251__AlterPortalModules()

BEGIN
 SET SQL_SAFE_UPDATES=0;
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_portal_modules'
 AND column_name ='table_name')) THEN
 
  ALTER TABLE `applicant_portal_modules`
   ADD COLUMN `table_name` VARCHAR(50) NULL AFTER `form_alias_name`;

 END IF;
 
IF EXISTS ((SELECT * FROM `applicant_portal_modules` WHERE module_code = 'STEP6_WORK_EXPERIENCE')) THEN 
	UPDATE `applicant_portal_modules`
	SET table_name = 'applicant_work_experience'
	WHERE module_code ='STEP6_WORK_EXPERIENCE';
END IF;

IF EXISTS ((SELECT * FROM `applicant_portal_modules` WHERE module_code = 'STEP1_PERSTONAL_DETAILS')) THEN 
	UPDATE `applicant_portal_modules`
	SET table_name = 'applicant_person'
	WHERE module_code ='STEP1_PERSTONAL_DETAILS';
END IF;

IF EXISTS ((SELECT * FROM `applicant_portal_modules` WHERE module_code = 'STEP5_EDUCATION_BACKGROUND')) THEN 
	UPDATE `applicant_portal_modules`
	SET table_name = 'applicant_education_histories'
	WHERE module_code ='STEP5_EDUCATION_BACKGROUND';
END IF;
SET SQL_SAFE_UPDATES=1;
END $$

-- Execute the stored procedure
CALL V20200406125251__AlterPortalModules() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200406125251__AlterPortalModules $$

DELIMITER ;