DELIMITER $$
DROP PROCEDURE IF EXISTS V20200522172009__Create_PaymentPlanDocument $$
CREATE PROCEDURE V20200522172009__Create_PaymentPlanDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_document')) THEN 
CREATE TABLE `payment_plan_document` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `documentTypeId` BIGINT NOT NULL,
  `paymentPlanId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_payment_plan_document_to_document_type_idx` (`documentTypeId` ASC),
  INDEX `fk_payment_plan_document_to_payment_plan_idx` (`paymentPlanId` ASC),
  INDEX `fk_payment_plan_document_to_user_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_payment_plan_document_to_document_type`
    FOREIGN KEY (`documentTypeId`)
    REFERENCES `document_types` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_document_to_payment_plan`
    FOREIGN KEY (`paymentPlanId`)
    REFERENCES `payment_plan` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_document_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20200522172009__Create_PaymentPlanDocument () $$ 
DROP PROCEDURE IF EXISTS V20200522172009__Create_PaymentPlanDocument $$ 
DELIMITER ;