DELIMITER $$
DROP PROCEDURE IF EXISTS V20200524161702__Create_StudentPaymentPlanEnrollment $$
CREATE PROCEDURE V20200524161702__Create_StudentPaymentPlanEnrollment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_payment_plan_enrollment')) THEN 
CREATE TABLE `student_payment_plan_enrollment` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `studentId` BIGINT NOT NULL,
  `paymentPlanId` BIGINT NOT NULL,
  `admissionId` BIGINT NOT NULL,
  `progBatchSeatConfigId` BIGINT NOT NULL,
  `progBatchPeriodConfigId` BIGINT NOT NULL,
  `enrolledById` BIGINT NOT NULL,
  `unenrolledById` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_student_payment_plan_enrollment_to_student_idx` (`studentId` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_admission_idx` (`admissionId` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_PBSC_idx` (`progBatchSeatConfigId` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_PBPC_idx` (`progBatchPeriodConfigId` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_enrolled_by_idx` (`enrolledById` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_unenrolled_by_idx` (`unenrolledById` ASC) ,
  INDEX `fk_student_payment_plan_enrollment_to_lastUpdated_by_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_student`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_payment_plan`
    FOREIGN KEY (`paymentPlanId`)
    REFERENCES `payment_plan`(`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_PBSC`
    FOREIGN KEY (`progBatchSeatConfigId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_PBPC`
    FOREIGN KEY (`progBatchPeriodConfigId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_enrolled_by`
    FOREIGN KEY (`enrolledById`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_unenrolled_by`
    FOREIGN KEY (`unenrolledById`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_payment_plan_enrollment_to_lastUpdated_by`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200524161702__Create_StudentPaymentPlanEnrollment () $$ 
DROP PROCEDURE IF EXISTS V20200524161702__Create_StudentPaymentPlanEnrollment $$ 
DELIMITER ;