DELIMITER $$

DROP PROCEDURE IF EXISTS V20200603142025__AlterDataRequirement $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200603142025__AlterDataRequirement()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='guideline')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup` ADD COLUMN `guideline` TEXT NULL AFTER `related_person_address`;
  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='document_path')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup` ADD COLUMN `document_path` VARCHAR(255) NULL AFTER `guideline`;
  
  END IF;
  
END $$

-- Execute the stored procedure
CALL V20200603142025__AlterDataRequirement $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200603142025__AlterDataRequirement $$
 
DELIMITER ;