DELIMITER $$
DROP PROCEDURE IF EXISTS V20200608120556__Create_outcome_marks_view $$
CREATE PROCEDURE V20200608120556__Create_outcome_marks_view()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='outcome_marks_view')) THEN 
CREATE 
   OR REPLACE
VIEW `outcome_marks_view` AS
select
       distinct
        academyLoc.id as academy_location_id,
academyLoc.academyCode as academy_code,
academyLoc.displayName as academy_display_name,
academy.academyName as academy,
   academyLoc.locationName as location_name,
   programGroup.groupName as program_group,
program.programName as program,
program.programShortName as program_short_name,
program.programNameToBePrint as program_name_to_be_print,
intakeYears.itemValue as intake_year,
batch.batchName as batch_name,
academicT.itemValue as academic_term,
progBatchPeriodConfig.printName as period,
progBatchPeriodConfig.id as period_id,
user.code as student_id,
person.printName as student_name,
course.nameToBePrinted as course,
course.courseShortName as course_short_name,
course.courseCode as course_code,
courseVarient.courseVariantDescription as course_variant,
section.sectionCode as section_code,
        section.alternateName as section_name ,
manageCourseOutcomes.courseOutComeCode as course_outcome,
        correlationLevel.levelPercentage as weightage,
        evaluationPlan.printNameInMarksheet as assessment_scheme,
evaluationPlanLevelTwo.levelName as assessment_level,
evalSeqDetail.detailSequenceNumber as event,
examEventQuestionDetail.questionNumber as question_number,
        this.effectiveMarks as effective_marks,
        this.effectiveMaxMarks as effective_max_marks
     
    from
        exam_question_courseoutcome_marks_detail this
    inner join
        event_question_detail_mapping eventQuestionDetailMapping
            on this.eventQuestionDetailsMappingId=eventQuestionDetailMapping.id
    inner join
        obe_correlation_level correlationLevel
            on eventQuestionDetailMapping.correlationId=correlationLevel.id
    inner join
        manage_course_outcomes manageCourseOutcomes
            on eventQuestionDetailMapping.manageCourseOutComesId=manageCourseOutcomes.id
   inner join
        courses course
            on manageCourseOutcomes.courseId=course.id
   inner join
        program_batch_course_param programBatchCourseParam
            on course.id=programBatchCourseParam.courseId
   inner join
        course_variants courseVarient
            on programBatchCourseParam.courseVarientId=courseVarient.id
    inner join
        prog_batch_course_details progBatchCourseDetails
            on courseVarient.id=progBatchCourseDetails.courseVarientId
    inner join
        prog_batch_period_config progBatchPeriodConfig
            on progBatchCourseDetails.programBatchPeriodConfigId=progBatchPeriodConfig.id
   inner join
        academic_term academicT
            on progBatchPeriodConfig.academicTermId=academicT.id
    left outer join
        batches batch
            on progBatchPeriodConfig.programBatchId=batch.id
   left outer join
        intake_year intakeYears
            on batch.intakeYearId=intakeYears.id
    left outer join
        programs program
            on batch.programId=program.id
    left outer join
        academy_location academyLoc
            on program.academyLocationId=academyLoc.id
    left outer join
        academies academy
            on academyLoc.academyId=academy.id
    left outer join
        program_group programGroup
            on program.programGroupId=programGroup.id
    left outer join
        sections section
            on programBatchCourseParam.sectionId=section.id
   inner join
        question_paper_student_details questionPaperStudentDetails
            on this.questionPaperStudentDetailsId=questionPaperStudentDetails.id
    left outer join
        admission admission20_
            on questionPaperStudentDetails.admissionId=admission20_.id
    left outer join
        students student
            on admission20_.studentId=student.userId
    left outer join
        users user
            on student.userId=user.id
    left outer join
        persons person
            on student.personId=person.id
    left outer join
        exam_event_question_detail examEventQuestionDetail
            on questionPaperStudentDetails.examEventQuestionDetailsId=examEventQuestionDetail.id
    left outer join
        eval_seq_detail evalSeqDetail
            on examEventQuestionDetail.eventId=evalSeqDetail.id
    inner join
        evaluation_sequence evaluationSequence
            on evalSeqDetail.evalSequenceId=evaluationSequence.id
    inner join
        evaluation_plan_level_two evaluationPlanLevelTwo
            on evaluationSequence.evalPlanLevelTwoId=evaluationPlanLevelTwo.id
    inner join
        evaluation_plan_level_one evaluationPlanLevelOne
            on evaluationPlanLevelTwo.evalPlanLevelOneId=evaluationPlanLevelOne.id
    inner join
        evaluation_plan evaluationPlan
            on evaluationPlanLevelOne.evaluationPlanId=evaluationPlan.id;
END IF; 

END $$
CALL V20200608120556__Create_outcome_marks_view () $$ 
DROP PROCEDURE IF EXISTS V20200608120556__Create_outcome_marks_view $$ 
DELIMITER ;