DELIMITER $$

DROP PROCEDURE IF EXISTS V20200616182720__AlterPersonAddColumn $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200616182720__AlterPersonAddColumn()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='correspondence_language')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `correspondence_language` BIGINT(20) NULL DEFAULT NULL;
    
    set foreign_key_checks=0;
	ALTER TABLE `persons`  
	ADD CONSTRAINT `fk_persons_correspondence_language`
	FOREIGN KEY (`correspondence_language`)
	REFERENCES `multi_language` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='contact_language')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `contact_language` BIGINT(20) NULL DEFAULT NULL;
    
     set foreign_key_checks=0;
	ALTER TABLE `persons` 
	ADD CONSTRAINT `fk_persons_contact_language`
	FOREIGN KEY (`contact_language`)
	REFERENCES `multi_language` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='wheel_chair_required')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `wheel_chair_required` BIT(1) NULL DEFAULT NULL;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='are_you_refugee')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `are_you_refugee` BIT(1) NULL DEFAULT NULL;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='is_tertiary_institution')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `is_tertiary_institution` BIT(1) NULL DEFAULT NULL;
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='secondary_citizenship')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `secondary_citizenship` BIGINT(20) NULL DEFAULT NULL;
    
      set foreign_key_checks=0;
	ALTER TABLE `persons` 
	ADD CONSTRAINT `fk_persons_secondary_citizenship`
	FOREIGN KEY (`secondary_citizenship`)
	REFERENCES `nationalities` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='support_document')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `support_document` VARCHAR(255) NULL DEFAULT NULL;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='isPermanentResident')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `isPermanentResident` BIT(1) NULL DEFAULT NULL;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='isAsylumSeeker')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `isAsylumSeeker` BIT(1) NULL DEFAULT NULL;
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='idTypeId')) THEN
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `idTypeId` BIGINT(20) NULL DEFAULT NULL;
    
    ALTER TABLE `persons`
	ADD CONSTRAINT `fk_person_idtype`
  	FOREIGN KEY (`idTypeId`) 
  	REFERENCES `id_type` (`id`)
  	ON DELETE NO ACTION 
  	ON UPDATE NO ACTION;
  END IF;
  
END $$

-- Execute the stored procedure
CALL V20200616182720__AlterPersonAddColumn $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200616182720__AlterPersonAddColumn $$
 
DELIMITER ;