DELIMITER $$

DROP PROCEDURE IF EXISTS V20200702160255__Insert_UITRNSForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200702160255__Insert_UITRNSForPortal()

BEGIN
	 -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='AGREE_TERMS_CONDITION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','AGREE_TERMS_CONDITION','I have read the Registration Contract and I agree with the terms and conditions.','I have read the Registration Contract and I agree with the terms and conditions.','Ek het die Registrasiekontrak gelees en stem saam met die bepalings en voorwaardes.', 'Tôi đã đọc Hợp đồng đăng ký và tôi đồng ý với các điều khoản và điều kiện.',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ADDRESS_NOT_AVAILABLE_MSG')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','ADDRESS_NOT_AVAILABLE_MSG','Address not available','Address not available','Adres nie beskikbaar nie', 'Địa chỉ không có sẵn',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='UPLOAD')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','UPLOAD','Upload','Upload','oplaai', 'Tải lên',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='OK')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','OK','Ok','Ok','ok', 'đồng ý',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='NEXT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','NEXT','Next','Next','volgende', 'Kế tiếp',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SELECT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SELECT','Select','Select','Kies', 'Lựa chọn',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DASHBOARD')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','DASHBOARD','Dashboard','Dashboard','Dashboard', 'bảng điều khiển',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAGE_NOT_FOUND')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PAGE_NOT_FOUND','Page Not Found','Bladsy nie gevind nie','Is u seker, u wil die geselekteerde plaat uitvee?', 'Không tìm thấy trang',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAGE_NOT_EXIST')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PAGE_NOT_EXIST','The page you are looking for does not exist.','The page you are looking for does not exist.','Die bladsy waarna u soek bestaan ​​nie.', 'Trang bạn đang tìm kiếm không tồn tại.',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAGE_NOT_EXIST')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','HOME','Home','Home','huis', 'Trang Chủ',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EXAM_NAME')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','EXAM_NAME','Name of Exam','Name of Exam','Naam van die eksamen', 'Tên bài kiểm tra',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='REGISTRATION_ENROLMENT_NO')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','REGISTRATION_ENROLMENT_NO','Registration / Enrolment No.','Registration / Enrolment No.','Registrasie / Inskrywingsnr.', 'Số đăng ký / tuyển sinh',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SCORE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SCORE','Score','Score','telling', 'Ghi bàn',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PERCENTILE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PERCENTILE','Percentile','Percentile','persentiel', 'Phần trăm',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RANK_ONE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','RANK_ONE','Rank 1','Rank 1','Rang 1', 'Hạng 1',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RANK_TWO')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','RANK_TWO','Rank 2','Rank 2','Rang 2', 'Hạng 2',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SUBJECT_SPECIALIZATION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SUBJECT_SPECIALIZATION','Subject / Specialization(If Any)','Subject / Specialization(If Any)','Onderwerp / spesialisasie (indien van toepassing)', 'Môn học / Chuyên ngành (Nếu có)',now(),1);
 END IF;
 
END $$

-- Execute the stored procedure
CALL V20200702160255__Insert_UITRNSForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200702160255__Insert_UITRNSForPortal $$
 
DELIMITER ;