DELIMITER $$
DROP PROCEDURE IF EXISTS V20200714123222__Create_SAP_Applicant_Detail_View $$
CREATE PROCEDURE V20200714123222__Create_SAP_Applicant_Detail_View()
BEGIN

DROP VIEW IF EXISTS `sap_applicant_detail_view`;
	
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='sap_applicant_detail_view')) THEN 
CREATE    
VIEW `sap_applicant_detail_view` AS
SELECT 
aper.firstName AS First_Name,
aper.middleName AS Middle_Name,
aper.lastName AS Last_Name,
gen.itemValue AS Gender,
aper.birthDate AS Date_Of_Birth,
cntry.countryName AS Country,
aper.nationalID AS Id_Card_No,
app.code AS ID,
concat(aper.phoneAreaCode," ",aper.phoneNo) AS Phone_No,
aper.mobileNumber AS Mobile_No,
aper.emailId AS Email,
aper.alternateEmailId AS Alt_Email,
aper.printName AS Name_In_Bank,
apbd.accountNumber AS Bank_Acc_No,
at.itemValue AS Bank_Acc_Type,
apbd.bankName AS Bank_Name,
apbd.branchName AS Bank_Branch_Name,
apbd.IFSCode AS Bank_IFSC_Code,
aper.lastUpdate as Last_Update
FROM 
application app
INNER JOIN applicant_person aper on app.applicantPersonId=aper.id
LEFT JOIN gender gen on aper.genderId=gen.id
LEFT JOIN country cntry on aper.countryId=cntry.id
LEFT JOIN applicant_bank_details apbd on aper.bankDetailId=apbd.id
LEFT JOIN account_type at on apbd.accountTypeId=at.id
group by aper.id;
END IF; 

END $$
CALL V20200714123222__Create_SAP_Applicant_Detail_View() $$ 
DROP PROCEDURE IF EXISTS V20200714123222__Create_SAP_Applicant_Detail_View $$ 
DELIMITER ;