DELIMITER $$
DROP PROCEDURE IF EXISTS V20200817184227__Insert_OfferAlertAndConfirmTrans $$
CREATE PROCEDURE V20200817184227__Insert_OfferAlertAndConfirmTrans()

BEGIN

	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='CONFIRM_PROVISIONAL_OFFER')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','CONFIRM_PROVISIONAL_OFFER','Are you sure, you want to issue provisional offer?','Are you sure, you want to issue provisional offer?','Bạn có chắc chắn muốn đưa ra đề nghị tạm thời không?',"Is u seker dat u 'n voorlopige aanbod wil uitreik?",now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='ISSUE_PROVISIONAL_OFFER_MSG')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','ISSUE_PROVISIONAL_OFFER_MSG','Provisional Offer Issued Successfully','Provisional Offer Issued Successfully','Phiếu mua hàng tạm thời đã được phát hành thành công','Voorlopige aanbod word suksesvol uitgereik',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG','The provisional offer has been declined','The provisional offer has been declined','Đề nghị tạm thời đã bị từ chối','Die voorlopige aanbod is van die hand gewys',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='CONFIRM_RESEND_PROVISIONAL_OFFER')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','CONFIRM_RESEND_PROVISIONAL_OFFER','Are you sure, you want to resend the provisional offer?','Are you sure, you want to resend the provisional offer?','Bạn có chắc chắn muốn gửi lại đề nghị tạm thời không?','Is u seker, wil u die voorlopige aanbod weer inhandig?',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='RESEND_PROVISIONAL_OFFER_MSG')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','RESEND_PROVISIONAL_OFFER_MSG','Provisional Offer Resend Successfully','Provisional Offer Resend Successfully','Gửi lại phiếu mua hàng tạm thời thành công','Voorlopige aanbod word weer suksesvol ingedien',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='RESEND_PROVISIONAL_OFFER_MSG')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','RESEND_PROVISIONAL_OFFER_MSG','Provisional Offer Resend Successfully','Provisional Offer Resend Successfully','Gửi lại phiếu mua hàng tạm thời thành công','Voorlopige aanbod word weer suksesvol ingedien',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='DECLINE_PROVISIONAL_OFFER_CONFIRM_MESSAGE')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','DECLINE_PROVISIONAL_OFFER_CONFIRM_MESSAGE','Are you sure, you want to decline provisional offer?','Are you sure, you want to decline provisional offer?','Bạn có chắc chắn muốn từ chối đề nghị tạm thời không?','Weet u seker dat u die voorlopige aanbod wil weier?',now(),1);
	END IF;
	
END $$

CALL V20200817184227__Insert_OfferAlertAndConfirmTrans() $$
DROP PROCEDURE IF EXISTS V20200817184227__Insert_OfferAlertAndConfirmTrans $$
DELIMITER ;
